package org.apache.maven.plugin.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-plugin-plugin.<br/> Call <pre>  mvn plugin:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Sep 02 12:27:36 EDT 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.8)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
@SuppressWarnings( "all" )
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-plugin-plugin:2.9", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Plugin Plugin", 0 );
        append( sb, "The Plugin Plugin is used to create a Maven plugin descriptor for any Mojo\'s found in the source tree, to include in the JAR. It is also used to generate Xdoc files for the Mojos as well as for updating the plugin registry, the artifact metadata and a generic help goal.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "addPluginArtifactMetadata".equals( goal ) )
        {
            append( sb, "plugin:addPluginArtifactMetadata", 0 );
            append( sb, "Inject any plugin-specific artifact metadata to the project\'s artifact, for subsequent installation and deployment. The first use-case for this is to add the LATEST metadata (which is plugin-specific) for shipping alongside the plugin\'s artifact.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The prefix for the plugin goal.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "descriptor".equals( goal ) )
        {
            append( sb, "plugin:descriptor", 0 );
            append( sb, "Generate a plugin descriptor.\nNote: Phase is after the \'compilation\' of any scripts.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding of the source files.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The role names of mojo extractors to use. If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used. Example:\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.outputDirectory}/META-INF/maven)", 2 );
                append( sb, "The directory where the generated plugin.xml file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "skipDescriptor (Default: false)", 2 );
                append( sb, "A flag to disable generation of the plugin.xml in favor of a hand authored plugin descriptor.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "plugin:help", 0 );
            append( sb, "Display help information on maven-plugin-plugin.\nCall\n\u00a0\u00a0mvn\u00a0plugin:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "helpmojo".equals( goal ) )
        {
            append( sb, "plugin:helpmojo", 0 );
            append( sb, "Generates a HelpMojo class.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding of the source files.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The role names of mojo extractors to use. If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used. Example:\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "helpPackageName", 2 );
                append( sb, "The name of the package for the generated HelpMojo. By default, the package will be calculated based on the packages of the other plugin goals.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/plugin)", 2 );
                append( sb, "The directory where the generated HelpMojo file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources.", 3 );
                append( sb, "Expression: ${useJava5}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "plugin:report", 0 );
            append( sb, "Generates the Plugin\'s documentation report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding of the source files.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'. By default, this plugin applies a heuristic to derive a heuristic from the plugin\'s artifactId. It removes any occurrences of the regular expression -?maven-?, and then removes any occurrences of -?plugin-?.\nFor example, horsefeature-maven-plugin becomes horsefeather.\n\n(There is a special for maven-plugin-plugin; it is mapped to \'plugin\'.\n", 3 );
                append( sb, "Expression: ${goalPrefix}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2 );
                append( sb, "Report output directory.", 3 );
                append( sb, "", 0 );

                append( sb, "requirements", 2 );
                append( sb, "Specify some requirements to execute this plugin. Example:\n<requirements>\n\u00a0\u00a0<maven>2.0</maven>\n\u00a0\u00a0<jdk>1.4</jdk>\n\u00a0\u00a0<memory>256m</memory>\n\u00a0\u00a0<diskSpace>1m</diskSpace>\n\u00a0\u00a0<others>\n\u00a0\u00a0\u00a0\u00a0<property>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<name>SVN</name>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<value>1.4.6</value>\n\u00a0\u00a0\u00a0\u00a0</property>\n\u00a0\u00a0</others>\n</requirements>\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "skipReport (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip generating the report.", 3 );
                append( sb, "Expression: ${maven.plugin.report.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "updateRegistry".equals( goal ) )
        {
            append( sb, "plugin:updateRegistry", 0 );
            append( sb, "Update the user plugin registry (if it\'s in use) to reflect the version we\'re installing.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "skipUpdatePluginRegistry (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip updating the plugin registry.", 3 );
                append( sb, "Expression: ${maven.plugin.update.registry.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xdoc".equals( goal ) )
        {
            append( sb, "plugin:xdoc", 0 );
            append( sb, "Generate Xdoc files for the project mojos or goals.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding of the source files.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "extractors", 2 );
                append( sb, "The role names of mojo extractors to use. If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used. Example:\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3 );
                append( sb, "", 0 );

                append( sb, "goalPrefix", 2 );
                append( sb, "The goal prefix that will appear before the \':\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2 );
                append( sb, "The directory where the generated Xdoc files will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip invoking any goals or reports of the plugin.", 3 );
                append( sb, "Expression: ${maven.plugin.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List<String> lines = new ArrayList<String>();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List<String> lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
