/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<T>
implements Iterator<T> {
    private List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private int offset;
    private Iterator<T> iterator;

    public void addIterator(Iterator<T> iteratorT) {
        this.iterators.add(iteratorT);
    }

    public List<Iterator<T>> getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    @Override
    public boolean hasNext() {
        if (this.offset < this.iterators.size()) {
            return this.iterators.get(this.offset).hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        try {
            this.iterator = this.iterators.get(this.offset);
            if (!this.iterator.hasNext()) {
                ++this.offset;
            }
            return this.iterator.next();
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException("No more iterators to iterate over");
        }
    }

    @Override
    public void remove() {
        if (this.iterator == null) {
            throw new IllegalStateException("cannot remove an unitialized iterator entry");
        }
        this.iterator.remove();
    }
}

