/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.InversionArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.ArtifactIdPatternFilter;
import org.nuxeo.build.filters.CategoryFilter;
import org.nuxeo.build.filters.ClassifierPatternFilter;
import org.nuxeo.build.filters.DependencyRequiredPatternFilter;
import org.nuxeo.build.filters.DependsOnCategoryPatternFilter;
import org.nuxeo.build.filters.FilePatternFilter;
import org.nuxeo.build.filters.GroupPatternFilter;
import org.nuxeo.build.filters.IdPatternFilter;
import org.nuxeo.build.filters.ManifestBundleCategoryPatternFilter;
import org.nuxeo.build.filters.ScopePatternFilter;
import org.nuxeo.build.filters.TrailPatternFilter;
import org.nuxeo.build.filters.TypePatternFilter;
import org.nuxeo.build.filters.VersionPatternFilter;

public class PatternFilterFactory {
    private PatternFilterFactory() {
    }

    public static ArtifactFilter createGroupFilter(String pattern) {
        GroupPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new GroupPatternFilter(pattern.substring(1))) : new GroupPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createNameFilter(String pattern) {
        ArtifactIdPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new ArtifactIdPatternFilter(pattern.substring(1))) : new ArtifactIdPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createTypeFilter(String pattern) {
        TypePatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new TypePatternFilter(pattern.substring(1))) : new TypePatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createVersionFilter(String pattern) {
        VersionPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new VersionPatternFilter(pattern.substring(1))) : new VersionPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createClassifierFilter(String pattern) {
        ClassifierPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new ClassifierPatternFilter(pattern.substring(1))) : new ClassifierPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createScopeFilter(String pattern) {
        ScopePatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new ScopePatternFilter(pattern.substring(1))) : new ScopePatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createFileFilter(String pattern) {
        FilePatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new FilePatternFilter(pattern.substring(1))) : new FilePatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createTrailFilter(String pattern) {
        TrailPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new TrailPatternFilter(pattern.substring(1))) : new TrailPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createIdFilter(String pattern) {
        IdPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new IdPatternFilter(pattern.substring(1))) : new IdPatternFilter(pattern);
        return filter;
    }

    public static ArtifactFilter createBundleCategoryFilter(String pattern, AbstractNuxeoAssembler mojo) {
        ManifestBundleCategoryPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new ManifestBundleCategoryPatternFilter(pattern.substring(1), mojo)) : new ManifestBundleCategoryPatternFilter(pattern, mojo);
        return filter;
    }

    public static ArtifactFilter createDependsOnCategoryFilter(String pattern, AbstractNuxeoAssembler mojo) {
        DependsOnCategoryPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new DependsOnCategoryPatternFilter(pattern.substring(1), mojo)) : new DependsOnCategoryPatternFilter(pattern, mojo);
        return filter;
    }

    public static ArtifactFilter createDependencyRequiredFilter(String pattern, AbstractNuxeoAssembler mojo) {
        DependencyRequiredPatternFilter filter = null;
        filter = pattern.startsWith("!") ? new InversionArtifactFilter((ArtifactFilter)new DependencyRequiredPatternFilter(pattern.substring(1), mojo)) : new DependencyRequiredPatternFilter(pattern, mojo);
        return filter;
    }

    public static ArtifactFilter createCategoryFilter(String pattern, AbstractNuxeoAssembler mojo) {
        return new CategoryFilter(pattern, mojo);
    }
}

