/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.filters;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.PatternFilterFactory;

public class DependsOnCategoryPatternFilter
implements ArtifactFilter {
    private AbstractNuxeoAssembler mojo;
    private ArtifactFilter categoryFilter;
    private String pattern;

    public DependsOnCategoryPatternFilter(String pattern, AbstractNuxeoAssembler mojo) {
        this.mojo = mojo;
        this.pattern = pattern;
        this.categoryFilter = PatternFilterFactory.createBundleCategoryFilter(pattern, mojo);
    }

    public boolean include(Artifact artifact) {
        boolean include = false;
        Set<Artifact> dependencies = this.mojo.getArtifactDependencies(artifact);
        this.mojo.getLog().debug((CharSequence)(DependsOnCategoryPatternFilter.class + " filtering " + artifact + " on pattern " + this.pattern + " ..."));
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                Artifact resolvedDependency = this.mojo.getArtifact(dependency);
                if (!this.categoryFilter.include(resolvedDependency)) continue;
                include = true;
                break;
            }
        }
        this.mojo.getLog().debug((CharSequence)("filtering on pattern " + this.pattern + " result for " + artifact + " : " + include));
        return include;
    }
}

