/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.embedded;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.nuxeo.build.embedded.BundleInfo;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;

public class NuxeoAppBuilder {
    protected boolean copyEmbeddedJars = true;
    protected File home;
    protected File manifest;
    protected File nxserver;
    protected File nuxeo;
    protected JarFile targetJar;
    protected File tmp;
    protected File metaInf;
    protected LinkedList<BundleInfo> bundles = new LinkedList();
    protected BundleInfo cbundle = null;
    protected boolean excludeLibs = false;
    protected boolean excludeOsgi;
    protected boolean excludeJetty;

    public static void main(String[] args) throws Exception {
        File t = null;
        String home = null;
        String target = null;
        if (args.length == 0) {
            NuxeoAppBuilder.syntaxError();
        }
        if (args.length == 1) {
            home = ".";
            target = args[0];
        } else {
            home = args[0];
            target = args[1];
        }
        File h = home.startsWith("/") ? new File(home) : new File(new File("."), home);
        t = target.startsWith("/") ? new File(target) : new File(new File("."), target);
        NuxeoAppBuilder merger = new NuxeoAppBuilder();
        merger.process(h, t, null);
    }

    protected static void syntaxError() {
        System.err.println("Syntax error. Usage: <app> [nxserverInstallDir] targetJar");
        System.exit(1);
    }

    public void setExcludeOsgi(boolean excludeOsgi) {
        this.excludeOsgi = excludeOsgi;
    }

    public void setExcludeJetty(boolean excludeJetty) {
        this.excludeJetty = excludeJetty;
    }

    public void setExcludeLibs(boolean excludeLibs) {
        this.excludeLibs = excludeLibs;
    }

    public void setCopyEmbeddedJars(boolean copyEmbeddedJars) {
        this.copyEmbeddedJars = copyEmbeddedJars;
    }

    protected void pushBundle(BundleInfo bi) {
        if (bi.isRuntimeBundle) {
            this.bundles.addFirst(bi);
        } else {
            this.bundles.addLast(bi);
        }
        this.cbundle = bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File src, File target, File launcherJar) throws IOException {
        File homeDir = src;
        if (homeDir.isFile()) {
            homeDir = File.createTempFile("nuxeo-app-builder-src-", ".tmp");
            homeDir.delete();
            homeDir.mkdirs();
            ZipUtils.unzip((File)src, (File)homeDir);
            File[] files = homeDir.listFiles();
            if (files.length == 1 && files[0].isDirectory()) {
                File tmp = homeDir;
                homeDir = File.createTempFile("nuxeo-app-builder-src-", ".tmp");
                homeDir.delete();
                homeDir.mkdirs();
                files[0].renameTo(homeDir);
                FileUtils.deleteTree((File)tmp);
            }
        }
        try {
            File bundles;
            File lib;
            File web;
            File nxwar;
            File cfg;
            this.initialize(homeDir);
            if (launcherJar != null) {
                ZipUtils.unzip((File)launcherJar, (File)this.tmp);
            }
            if ((cfg = this.getConfigDirectory()).isDirectory()) {
                System.out.println("Copying configuration");
                File dst = new File(this.nxserver, "config");
                dst.mkdir();
                this.copyResources(cfg, dst);
            }
            if ((nxwar = this.getNuxeoWar()).isDirectory()) {
                System.out.println("Copying Nuxeo WAR");
                File dst = new File(this.nxserver, "nuxeo.war");
                dst.mkdir();
                this.copyResources(nxwar, dst);
            }
            if ((web = this.getWebDirectory()).isDirectory()) {
                System.out.println("Copying web resources");
                File dst = new File(this.nxserver, "web/root.war/WEB-INF");
                dst.mkdirs();
                this.copyResources(web, dst);
            }
            if (!this.excludeLibs && (lib = this.getLibDirectory()).isDirectory()) {
                this.expandJars(lib);
            }
            if ((bundles = this.getBundlesDirectory()).isDirectory()) {
                this.expandBundles(bundles);
            }
            System.out.println("Writing manifest");
            this.writeManifest();
            this.writeDescriptors();
            this.processingDone();
            System.out.println("Creating target file: " + target);
            ZipUtils.zip((File[])this.tmp.listFiles(), (File)target);
        }
        finally {
            System.out.println("Cleaning up ...");
            this.cleanup();
            if (homeDir.isDirectory()) {
                FileUtils.deleteTree((File)homeDir);
            }
        }
        System.out.println("Done.");
    }

    protected void cleanup() {
        if (this.tmp != null) {
            FileUtils.deleteTree((File)this.tmp);
        }
        this.home = null;
        this.bundles = new LinkedList();
        this.cbundle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDescriptors() throws IOException {
        PrintWriter p1 = new PrintWriter(new File(this.nuxeo, "activators"));
        PrintWriter p2 = new PrintWriter(new File(this.nuxeo, "components"));
        try {
            for (BundleInfo bi : this.bundles) {
                if (bi.activator != null) {
                    p1.println(bi.activator);
                }
                if (bi.components.isEmpty()) continue;
                for (String co : bi.components) {
                    p2.println(co);
                }
            }
        }
        finally {
            try {
                p1.close();
            }
            catch (Exception exception) {}
            p2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeManifest() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (BundleInfo bi : this.bundles) {
            if (bi.exports == null) continue;
            buf.append(bi.exports).append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        Manifest mf = new Manifest();
        Attributes attrs = mf.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(Attributes.Name.IMPLEMENTATION_VERSION, "5.2");
        attrs.put(Attributes.Name.IMPLEMENTATION_VENDOR, "Nuxeo");
        attrs.putValue("Created-By", "Nuxeo App builder");
        attrs.put(Attributes.Name.MAIN_CLASS, "org.nuxeo.embedded.NuxeoApp");
        attrs.putValue("Bundle-ManifestVersion", "2");
        attrs.putValue("Bundle-Version", "5.2");
        attrs.putValue("Bundle-Name", "Nuxeo Application");
        attrs.putValue("Bundle-SymbolicName", "org.nuxeo.embedded.application; singleton:=true");
        attrs.putValue("Bundle-Activator", "org.nuxeo.embedded.NuxeoAppActivator");
        attrs.putValue("Bundle-Vendor", "Nuxeo");
        attrs.putValue("Bundle-Category", "application");
        attrs.putValue("Export-Package", buf.toString());
        attrs.putValue("Bundle-ActivationPolicy", "lazy");
        attrs.putValue("Import-Package", "org.osgi.framework,org.eclipse.core.runtime");
        FileOutputStream out = new FileOutputStream(this.manifest);
        try {
            mf.write(out);
        }
        finally {
            out.close();
        }
    }

    protected void expandJars(File dir) throws IOException {
        for (File jar : dir.listFiles()) {
            this.processJar(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJar(File jar) throws IOException {
        if (this.excludeOsgi && jar.getName().startsWith("osgi")) {
            System.out.println("??? Excluding osgi library: " + jar);
            return;
        }
        if (jar.isFile() && jar.getPath().endsWith(".jar")) {
            System.out.println("Processing library: " + jar);
            File tmpLib = new File(this.tmp, jar + ".tmp");
            try {
                ZipUtils.unzip((File)jar, (File)tmpLib);
                this.copyLibResources(tmpLib);
            }
            finally {
                FileUtils.deleteTree((File)tmpLib);
            }
        }
    }

    protected void expandBundles(File dir) throws IOException {
        for (File jar : dir.listFiles()) {
            this.processBundle(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBundle(File jar) throws IOException {
        if (jar.isFile() && jar.getPath().endsWith(".jar")) {
            System.out.println("Processing bundle: " + jar);
            File tmpBundle = new File(this.tmp, jar + ".tmp");
            try {
                ZipUtils.unzip((File)jar, (File)tmpBundle);
                BundleInfo bi = null;
                try {
                    bi = new BundleInfo(tmpBundle);
                }
                catch (IllegalArgumentException e) {
                    this.copyLibResources(tmpBundle);
                    FileUtils.deleteTree((File)tmpBundle);
                    return;
                }
                this.pushBundle(bi);
                this.copyBundleResources(bi);
            }
            finally {
                FileUtils.deleteTree((File)tmpBundle);
            }
        }
        if (jar.isDirectory()) {
            System.err.println("! Bundle directories support is not yet implemented. Failed processing: " + jar);
        }
    }

    protected File getLibDirectory() {
        return new File(this.home, "lib");
    }

    protected File getBundlesDirectory() {
        return new File(this.home, "bundles");
    }

    protected File getWebDirectory() {
        return new File(this.home, "web/root.war/WEB-INF");
    }

    protected File getNuxeoWar() {
        return new File(this.home, "nuxeo.war");
    }

    protected File getConfigDirectory() {
        return new File(this.home, "config");
    }

    protected void initialize(File home) throws IOException {
        System.out.println("Initializing ...");
        this.home = home;
        if (this.tmp == null) {
            this.tmp = File.createTempFile("nuxeo-app-merger", ".tmp");
            this.tmp.delete();
            this.tmp.mkdirs();
        }
        this.metaInf = new File(this.tmp, "META-INF");
        this.metaInf.mkdir();
        this.manifest = new File(this.metaInf, "MANIFEST.MF");
        this.nxserver = new File(this.metaInf, "nuxeo/nxserver");
        this.nxserver.mkdirs();
        this.nuxeo = this.nxserver.getParentFile();
        this.runPreprocessor(home);
    }

    public void copyLibResources(File bundleDir) throws IOException {
        for (File file : bundleDir.listFiles()) {
            String name = file.getName();
            if ("META-INF".equals(name)) continue;
            this.copyResource(file, this.tmp);
        }
    }

    public void copyResources(File resDir, File dstDir) throws IOException {
        for (File file : resDir.listFiles()) {
            this.copyResource(file, dstDir);
        }
    }

    public void copyBundleResources(BundleInfo bi) throws IOException {
        if (bi.isWebBundle) {
            this.copyWebModuleResources(bi);
        } else {
            this.copyRegularBundleResources(bi);
        }
    }

    public void copyRegularBundleResources(BundleInfo bi) throws IOException {
        File metaInf = new File(bi.file, "META-INF");
        if (metaInf.isDirectory()) {
            this.copyBundleMetaInf(bi, metaInf);
        }
        for (File file : bi.file.listFiles()) {
            String name = file.getName();
            if ("META-INF".equals(name) || "module.xml".equals(name) || "skin".equals(name)) continue;
            this.copyResource(file, this.tmp);
        }
    }

    public void copyWebModuleResources(BundleInfo bi) throws IOException {
        File modules = new File(this.nxserver, "web/root.war/modules");
        modules.mkdirs();
        File module = new File(modules, bi.id);
        module.mkdir();
        this.copyResources(bi.file, module);
        this.copyRegularBundleResources(bi);
    }

    protected void copyBundleMetaInf(BundleInfo bi, File file) throws IOException {
        File metaInf = new File(this.tmp, "META-INF");
        for (File f : file.listFiles()) {
            String name = f.getName();
            if ("MANIFEST.MF".equals(name) || "maven".equals(name)) continue;
            this.copyResource(f, metaInf);
        }
    }

    protected void copyResource(File file, File toDir) throws IOException {
        String name = file.getName();
        if (name.endsWith(".jar")) {
            if (this.copyEmbeddedJars) {
                System.out.println("??? Expanding embedded JAR: " + name);
                ZipUtils.unzip((File)file, (File)this.tmp);
            } else {
                System.out.println("!!! Skiping embedded JAR: " + name);
            }
            return;
        }
        if (file.isDirectory()) {
            toDir = new File(toDir, name);
            toDir.mkdir();
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.copyResource(f, toDir);
                }
            }
        } else {
            File dst = new File(toDir, name);
            if (dst.exists()) {
                if (!this.mergeFile(name, dst, file)) {
                    System.err.println("!!! Resource already exists: " + dst.getAbsolutePath());
                }
            } else {
                FileUtils.copyFile((File)file, (File)dst);
            }
        }
    }

    protected boolean mergeFile(String name, File oldFile, File newFile) throws IOException {
        if (name.equals("deployment-fragment.xml") || name.equals("NOTICE") || name.equals("LICENSE") || name.equals("web-types") || name.equals("module.xml")) {
            return true;
        }
        if (this.cbundle != null && this.cbundle.components != null) {
            int size = this.cbundle.components.size();
            for (int i = 0; i < size; ++i) {
                String co = this.cbundle.components.get(i);
                if (!newFile.equals(new File(this.cbundle.file, co))) continue;
                File f = new File(co);
                String fname = this.cbundle.id + "_" + name;
                co = f.getParentFile().getPath() + "/" + fname;
                this.cbundle.components.set(i, co);
                System.out.println("??? resolved conflict -> renamed file <" + newFile + "> to " + co);
                FileUtils.copyFile((File)newFile, (File)new File(oldFile.getParent(), fname));
                return true;
            }
        }
        return false;
    }

    protected void processingDone() throws IOException {
        new File(this.tmp, "LICENSE").delete();
        new File(this.tmp, "LICENSE.txt").delete();
        new File(this.tmp, "NOTICE").delete();
        new File(this.tmp, "NOTICE.txt").delete();
        new File(this.tmp, "README.txt").delete();
        new File(this.tmp, "module.xml").delete();
        new File(this.tmp, "web.xml").delete();
        FileUtils.deleteTree((File)new File(this.tmp, "javax/management"));
        if (this.excludeJetty) {
            FileUtils.deleteTree((File)new File(this.tmp, "org/mortbay"));
        }
    }

    protected void runPreprocessor(File home) {
        if (!new File(home, "OSGI-INF/deployment-container.xml").isFile()) {
            return;
        }
        File file = this.findFile(new File(home, "bundles"), "nuxeo-runtime-deploy-");
        if (file != null) {
            try {
                this.runPreprocessor(home, file);
            }
            catch (Exception e) {
                throw new Error("Failed to run nuxeo preprocessor", e);
            }
        } else {
            System.out.println("No nuxeo preprocessor found.");
        }
    }

    protected File findFile(File dir, String prefix) {
        String[] names;
        for (String name : names = dir.list()) {
            if (!name.startsWith(prefix)) continue;
            return new File(dir, name);
        }
        return null;
    }

    protected void runPreprocessor(File home, File preprocessor) throws Exception {
        File bundles;
        MutableURLClassLoader cl = new MutableURLClassLoader();
        File libs = new File(home, "lib");
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getPath().endsWith(".jar")) continue;
                cl.addURL(file.toURI().toURL());
            }
        }
        if ((files = (bundles = new File(home, "bundles")).listFiles()) != null) {
            for (File file : files) {
                if (!file.getPath().endsWith(".jar")) continue;
                cl.addURL(file.toURI().toURL());
            }
        }
        System.out.println("# Running preprocessor ...");
        Class<?> klass = cl.loadClass("org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor");
        Method main = klass.getMethod("main", String[].class);
        main.invoke(null, new Object[]{new String[]{home.getAbsolutePath()}});
        System.out.println("# Preprocessing done.");
    }

    class MutableURLClassLoader
    extends URLClassLoader {
        public MutableURLClassLoader() {
            super(new URL[0], NuxeoAppBuilder.class.getClassLoader());
        }

        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

