/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Manifest;

public class BundleInfo {
    public final File file;
    public final Manifest mf;
    public final String id;
    public final String exports;
    public final List<String> components;
    public final String activator;
    public final boolean isRuntimeBundle;
    public final boolean isWebBundle;

    public BundleInfo(File bundleDir) throws IOException {
        this.file = bundleDir;
        this.mf = this.getManifest(bundleDir);
        this.id = this.getSymbolicName(this.mf);
        this.isRuntimeBundle = "org.nuxeo.runtime".equals(this.id);
        this.isWebBundle = new File(this.file, "module.xml").isFile();
        String val = null;
        this.activator = this.isRuntimeBundle ? null : ((val = this.mf.getMainAttributes().getValue("Bundle-Activator")) != null ? val.trim() : null);
        this.components = new ArrayList<String>();
        val = this.mf.getMainAttributes().getValue("Nuxeo-Component");
        if (val != null && (val = val.trim()).length() > 0) {
            String[] ar = val.split("\\s*,\\s*");
            this.components.addAll(Arrays.asList(ar));
        }
        this.exports = (val = this.mf.getMainAttributes().getValue("Export-Package")) != null ? ((val = val.trim()).length() > 0 ? val : null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getManifest(File bundleDir) throws IOException {
        File mani = new File(bundleDir, "META-INF/MANIFEST.MF");
        FileInputStream in = new FileInputStream(mani);
        try {
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        finally {
            in.close();
        }
    }

    protected String getSymbolicName(Manifest mf) {
        String name = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (name == null) {
            throw new IllegalArgumentException("No symbolic name found");
        }
        int p = name.indexOf(59);
        if (p > -1) {
            name = name.substring(0, p);
        }
        return name;
    }
}

