/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.ZipEntrySetFilter;
import org.nuxeo.build.assembler.resource.Resource;
import org.nuxeo.build.assembler.resource.ResourceIterator;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.resource.ZipEntryResource;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;
import org.nuxeo.build.assembler.xml.ExcludePatterns;
import org.nuxeo.build.assembler.xml.IncludePatterns;
import org.nuxeo.common.utils.ZipFileIterator;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="zipEntrySet")
public class ZipEntrySet
implements ResourceSet {
    @XContext(value="mojo")
    private AbstractNuxeoAssembler mojo;
    @XNode(value="@id")
    private String id;
    private String zipFile;
    private String artifactId;
    @XNode(value="includes")
    private IncludePatterns includes;
    @XNode(value="excludes")
    private ExcludePatterns excludes;
    @XNode(value="@profile")
    private String profile;

    @XNode(value="file")
    public void setParametrizedFile(String value) {
        this.zipFile = this.mojo.expandVars(value);
    }

    @XNode(value="artifact")
    public void setParametrizeAtrifact(String artifactId) {
        this.artifactId = this.mojo.expandVars(artifactId);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(String zipFile) {
        this.zipFile = zipFile;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public IncludePatterns getIncludes() {
        return this.includes;
    }

    public void setIncludes(IncludePatterns includes) {
        this.includes = includes;
    }

    public ExcludePatterns getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ExcludePatterns excludes) {
        this.excludes = excludes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZipFileIterator getZipFileIterator() throws Exception {
        File file = null;
        if (this.zipFile == null) {
            if (this.artifactId == null) {
                throw new IllegalArgumentException("A zip entry set must have a 'file' or an 'artifact' sub-elements");
            }
            ArtifactDescriptor ad = ArtifactDescriptor.fromVersionId(this.artifactId);
            Artifact artifact = null;
            if (this.artifactId.indexOf("*") > -1 || ad.version == null) {
                Set artifacts = this.mojo.getProject().getArtifacts();
                ArtifactFilter filter = ad.getFilter();
                for (Artifact a : artifacts) {
                    if (!filter.include(a)) continue;
                    artifact = a;
                    break;
                }
            } else {
                artifact = this.mojo.getArtifactResolver().resolve(ad);
                if (artifact == null) {
                    throw new Error("Failed to process zip entry set: No such artifact: " + this.artifactId);
                }
            }
            if (artifact == null) throw new MojoExecutionException("Artifact cannot be found: " + this.artifactId);
            file = artifact.getFile();
        } else {
            file = new File(this.zipFile);
        }
        ZipEntrySetFilter filter = null;
        if (this.includes == null && this.excludes == null) return new ZipFileIterator(file, filter);
        filter = new ZipEntrySetFilter(this.includes, this.excludes);
        return new ZipFileIterator(file, filter);
    }

    @Override
    public Iterator<Resource> iterator() {
        try {
            final ZipFileIterator it = this.getZipFileIterator();
            return new ResourceIterator<ZipEntry>((Iterator)it){

                @Override
                protected Resource adapt(ZipEntry object) {
                    return new ZipEntryResource(object, it.getZipFile());
                }
            };
        }
        catch (Exception e) {
            AbstractNuxeoAssembler.getLogger().error((Throwable)e);
            return null;
        }
    }
}

