/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.xml;

import java.util.Map;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.filters.OrArtifactFilter;
import org.nuxeo.build.filters.PatternFilterFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="artifact")
public class ArtifactDescriptor {
    private static final String CATEGORIES_SEPARATOR = ",";
    @XContext(value="mojo")
    protected AbstractNuxeoAssembler mojo;
    protected String group;
    protected String name;
    @XNode(value="@type")
    protected String type;
    protected String version;
    @XNode(value="@scope")
    protected String scope;
    @XNode(value="@classifier")
    protected String classifier;
    @XNode(value="@file")
    protected String file;
    @XNode(value="@trail")
    protected String trail;
    @XNode(value="@transitive")
    protected String transitive;
    @XNode(value="@category")
    protected String categories;
    @XNode(value="@includeDependsOnCategory")
    protected boolean includeDependsOnCategory = true;
    @XNode(value="@profile")
    protected String profile;
    private ArtifactFilter filter;

    @XNode(value="@group")
    void setParametrizedGroup(String value) {
        this.group = StringUtils.expandVars((String)value, (Map)this.mojo.getProperties());
    }

    @XNode(value="@name")
    void setParametrizedName(String value) {
        this.name = StringUtils.expandVars((String)value, (Map)this.mojo.getProperties());
    }

    @XNode(value="@version")
    void setParametrizedVersion(String value) {
        this.version = StringUtils.expandVars((String)value, (Map)this.mojo.getProperties());
    }

    public static ArtifactDescriptor fromVersionId(String versionId) {
        String[] ar = StringUtils.split((String)versionId, (char)':', (boolean)false);
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.group = ar[0];
        if (ar.length > 1) {
            ad.name = ar[1];
        }
        if (ar.length > 2) {
            ad.version = ar[2];
        }
        if (ar.length > 3) {
            ad.type = ar[3];
        }
        if (ar.length > 4) {
            ad.classifier = ar[4];
        }
        return ad;
    }

    public ArtifactFilter getFilter() {
        if (this.filter == null) {
            AndArtifactFilter andFilter = new AndArtifactFilter();
            if (this.group != null) {
                andFilter.add(PatternFilterFactory.createGroupFilter(this.group));
            }
            if (this.name != null) {
                andFilter.add(PatternFilterFactory.createNameFilter(this.name));
            }
            if (this.type != null) {
                andFilter.add(PatternFilterFactory.createTypeFilter(this.type));
            }
            if (this.scope != null) {
                andFilter.add(PatternFilterFactory.createScopeFilter(this.scope));
            }
            if (this.version != null) {
                andFilter.add(PatternFilterFactory.createVersionFilter(this.version));
            }
            if (this.classifier != null) {
                andFilter.add(PatternFilterFactory.createClassifierFilter(this.classifier));
            }
            if (this.file != null) {
                andFilter.add(PatternFilterFactory.createFileFilter(this.file));
            }
            if (this.trail != null) {
                andFilter.add(PatternFilterFactory.createTrailFilter(this.trail));
            }
            if (this.getCategories() != null && this.getCategories().length > 0) {
                OrArtifactFilter orFilter = new OrArtifactFilter();
                for (String category : this.getCategories()) {
                    ArtifactFilter bundleCategoryFilter = PatternFilterFactory.createBundleCategoryFilter(category, this.mojo);
                    if (this.includeDependsOnCategory) {
                        orFilter.add(PatternFilterFactory.createDependsOnCategoryFilter(category, this.mojo));
                    }
                    orFilter.add(bundleCategoryFilter);
                }
                andFilter.add((ArtifactFilter)orFilter);
            }
            this.filter = andFilter;
        }
        return this.filter;
    }

    public String[] getCategories() {
        return this.categories != null ? this.categories.split(CATEGORIES_SEPARATOR) : null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

