/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.commands.Command;
import org.nuxeo.build.assembler.resource.CompositeResourceSet;
import org.nuxeo.build.assembler.resource.FileResource;
import org.nuxeo.build.assembler.resource.Resource;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.Files;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="assemble")
public class AssembleCommand
implements Command {
    @XContext(value="mojo")
    private AbstractNuxeoAssembler mojo;
    @XNodeList(value="file", type=String[].class, componentType=String.class)
    private String[] files;
    @XNodeList(value="set", type=String[].class, componentType=String.class)
    private String[] sets;
    @XNode(value="outputFile")
    private String outputFile;
    @XNode(value="pack")
    private boolean pack;
    @XNode(value="unpack")
    private boolean unpack;
    @XNode(value="delete")
    private boolean delete;
    @XNode(value="unpackInNewDirectory")
    private boolean unpackInNewDirectory;

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getPack() {
        return this.pack;
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public boolean getUnpack() {
        return this.unpack;
    }

    public void setUnpackInNewDirectory(boolean unpackInNewDirectory) {
        this.unpackInNewDirectory = unpackInNewDirectory;
    }

    public boolean getUnpackInNewDirectory() {
        return this.unpackInNewDirectory;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public String[] getSets() {
        return this.sets;
    }

    public void setSets(String[] sets) {
        this.sets = sets;
    }

    @Override
    public void execute(MavenProject project, Map<Object, Object> context) throws Exception {
        File outDir = (File)context.get("outputDirectory");
        if (this.outputFile != null) {
            outDir = new File(outDir, this.outputFile);
        }
        CompositeResourceSet cset = new CompositeResourceSet();
        if (this.files != null && this.files.length > 0) {
            Files filesSet = new Files();
            filesSet.setMojo(this.mojo);
            filesSet.setFiles(this.files);
            cset.add(filesSet);
        }
        if (this.sets != null && this.sets.length > 0) {
            Map setMap = (Map)context.get("resourceSets");
            for (String setName : this.sets) {
                ResourceSet set = (ResourceSet)setMap.get(setName = this.mojo.expandVars(setName));
                if (set != null) {
                    this.mojo.getLog().debug((CharSequence)("add " + set));
                    cset.add(set);
                    continue;
                }
                this.mojo.getLog().warn((CharSequence)("Skip unfound set: " + setName));
            }
        }
        if (this.pack) {
            outDir.getParentFile().mkdirs();
            this.zip(cset, outDir);
        } else if (this.unpack) {
            outDir.mkdirs();
            this.unzip(cset, outDir);
        } else if (this.delete) {
            this.remove(cset, outDir);
        } else {
            outDir.mkdirs();
            this.copy(cset, outDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ResourceSet set, File outDir) throws IOException {
        for (Resource res : set) {
            File toFile = new File(outDir, res.getName());
            if (!res.isFile()) {
                toFile.mkdirs();
                this.mojo.getLog().debug((CharSequence)("Skipping resource (directory) " + res.getName()));
                continue;
            }
            toFile.getParentFile().mkdirs();
            InputStream in = res.getStream();
            try {
                this.mojo.getLog().info((CharSequence)("Copying " + res.getName() + " to " + toFile.getPath()));
                FileUtils.copyToFile((InputStream)in, (File)toFile);
            }
            finally {
                in.close();
            }
        }
    }

    public void remove(ResourceSet set, File outDir) {
        for (Resource res : set) {
            if (!(res instanceof FileResource)) {
                throw new Error("Only File Resources can be used on remove command");
            }
            File file = new File(outDir, res.getName());
            this.mojo.getLog().info((CharSequence)("Deleting " + file.getAbsolutePath()));
            if (file.isFile()) {
                file.delete();
                continue;
            }
            FileUtils.deleteTree((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(ResourceSet set, File file) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(file));
        try {
            for (Resource res : set) {
                if (!res.isFile()) continue;
                this.mojo.getLog().info((CharSequence)("Compressing " + res.getName() + " to " + file.getPath()));
                ZipUtils._zip((String)res.getName(), (InputStream)res.getStream(), (ZipOutputStream)zout);
            }
        }
        finally {
            zout.close();
        }
    }

    public void unzip(ResourceSet set, File dir) throws IOException {
        for (Resource res : set) {
            File target = this.unpackInNewDirectory ? new File(dir, res.getName()) : dir;
            this.mojo.getLog().info((CharSequence)("Uncompressing " + res.getName() + " to " + target.getPath()));
            ZipUtils.unzip((InputStream)res.getStream(), (File)target);
        }
    }
}

