/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.build.assembler.xml.ArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolver {
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteRepos;
    protected ArtifactFactory factory;
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;
    private MavenProject project;

    public ArtifactResolver(MavenProject project, ArtifactRepository local, List<ArtifactRepository> remoteRepos, org.apache.maven.artifact.resolver.ArtifactResolver resolver, ArtifactFactory factory) {
        this.project = project;
        this.local = local;
        this.remoteRepos = remoteRepos;
        this.factory = factory;
        this.resolver = resolver;
    }

    public Artifact resolve(ArtifactDescriptor ad) throws MojoExecutionException {
        return this.resolve(ad, "runtime");
    }

    public Artifact resolve(ArtifactDescriptor ad, String scope) throws MojoExecutionException {
        Artifact artifact;
        if (ad.getGroup() == null || ad.getName() == null) {
            throw new MojoExecutionException("Invalid artifact descriptor. It should contains at least the groupId and artifactId");
        }
        if (ad.getScope() == null) {
            ad.setScope(scope);
        }
        if (ad.getType() == null) {
            ad.setType("jar");
        }
        VersionRange vr = null;
        if (ad.getVersion() != null) {
            try {
                vr = VersionRange.createFromVersionSpec((String)ad.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                AbstractNuxeoAssembler.getLogger().error((CharSequence)e.getMessage());
                vr = VersionRange.createFromVersion((String)ad.getVersion());
            }
        }
        if ((artifact = this.resolveFromAttachedArtifacts(ad.getGroup(), ad.getName(), vr, ad.getType(), ad.getClassifier())) != null) {
            AbstractNuxeoAssembler.getLogger().debug((CharSequence)("comparison: " + artifact.equals(this.factory.createDependencyArtifact(ad.getGroup(), ad.getName(), vr, ad.getType(), ad.getClassifier(), ad.getScope()))));
            return artifact;
        }
        artifact = this.factory.createDependencyArtifact(ad.getGroup(), ad.getName(), vr, ad.getType(), ad.getClassifier(), ad.getScope());
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private Artifact resolveFromAttachedArtifacts(String group, String name, VersionRange vr, String type, String classifier) {
        AttachedArtifact artifactFound = null;
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (AttachedArtifact attachedArtifact : attachedArtifacts) {
            if (group != null && !group.equals(attachedArtifact.getGroupId()) || name != null && !name.equals(attachedArtifact.getArtifactId()) || vr != null && !vr.containsVersion((ArtifactVersion)new DefaultArtifactVersion(attachedArtifact.getVersion())) || type != null && !type.equals(attachedArtifact.getType()) || classifier != null && !classifier.equals(attachedArtifact.getClassifier())) continue;
            artifactFound = attachedArtifact;
            break;
        }
        return artifactFound;
    }

    public void resolve(Artifact artifact) throws MojoExecutionException {
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
    }
}

