/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.assembler;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.nuxeo.build.DependencyTree;
import org.nuxeo.build.DependencyTreeFull;
import org.nuxeo.build.Node;
import org.nuxeo.build.assembler.ArtifactResolver;
import org.nuxeo.build.assembler.Assembly;
import org.nuxeo.build.assembler.NuxeoAssembler;
import org.nuxeo.build.assembler.ProjectDependencySet;
import org.nuxeo.build.assembler.resource.ResourceSet;
import org.nuxeo.build.assembler.xml.AssemblyBuilder;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNuxeoAssembler
extends AbstractMojo
implements NuxeoAssembler {
    protected MavenProject project;
    protected String descriptor;
    protected String outputDirectory;
    private String targetFile;
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteArtifactRepositories;
    protected ArtifactFactory factory;
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;
    protected String format;
    protected String zipRoot;
    protected boolean runPreprocessor;
    protected Map<String, ResourceSet> resourceSets = new HashMap<String, ResourceSet>();
    protected ArtifactResolver artifactResolver;
    protected DependencyTree dependencyTree;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    protected File basedir;
    private static int offset = 0;
    private Properties props;
    protected static final ThreadLocal<Log> localLogger = new ThreadLocal<Log>(){

        @Override
        protected Log initialValue() {
            return null;
        }
    };

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    @Override
    public Map<String, ResourceSet> getResourceSetMap() {
        return this.resourceSets;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        if (this.artifactResolver == null) {
            this.artifactResolver = new ArtifactResolver(this.project, this.local, this.remoteArtifactRepositories, this.resolver, this.factory);
        }
        return this.artifactResolver;
    }

    @Override
    public boolean isProfileActivated(String id) {
        List profiles = this.project.getActiveProfiles();
        for (Profile p : profiles) {
            if (!p.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getZipRoot() {
        return this.zipRoot;
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public boolean isRunPreprocessor() {
        return this.runPreprocessor;
    }

    @Override
    public String getTargetFileName() {
        return this.targetFile;
    }

    public org.apache.maven.artifact.resolver.ArtifactResolver getResolver() {
        return this.resolver;
    }

    public DependencyTreeBuilder getDependencyTreeBuilder() {
        return this.dependencyTreeBuilder;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }

    public DependencyTree getDependencyTree() {
        if (this.dependencyTree == null) {
            Context ctx = new Context();
            ctx.setProperty("mojo", (Object)this);
            ctx.setProperty("project", (Object)this.getProject());
            ctx.setProperty("builder", (Object)this.getDependencyTreeBuilder());
            ctx.setProperty("repository", (Object)this.local);
            ctx.setProperty("factory", (Object)this.factory);
            ctx.setProperty("metadataSource", (Object)this.getArtifactMetadataSource());
            ctx.setProperty("collector", (Object)this.getArtifactCollector());
            this.artifactResolver = new ArtifactResolver(this.project, this.local, this.remoteArtifactRepositories, this.resolver, this.factory);
            ctx.setProperty("resolver", (Object)this.artifactResolver);
            this.dependencyTree = new DependencyTreeFull(ctx);
        }
        return this.dependencyTree;
    }

    public Set<Artifact> getArtifactDependencies(Artifact artifact) {
        HashSet<Artifact> result = null;
        DependencyTree tree = null;
        tree = this.getDependencyTree();
        this.getLog().debug((CharSequence)("search dependencies for " + artifact.getId()));
        Node artifactNode = tree.getNode(artifact.getId());
        if (artifactNode != null) {
            result = new HashSet<Artifact>();
            this.getLog().debug((CharSequence)artifactNode.getArtifact().toString());
            HashSet<String> nodesKnown = new HashSet<String>();
            this.collectChildrenArtifacts(artifactNode, result, nodesKnown);
        }
        return result;
    }

    private void collectChildrenArtifacts(Node root, Collection<Artifact> result, Set<String> nodesKnown) {
        String offsetString = "";
        if (this.getLog().isDebugEnabled()) {
            ++offset;
            for (int i = 0; i < offset; ++i) {
                offsetString = offsetString + " ";
            }
        }
        nodesKnown.add(root.getArtifact().getId());
        for (Node node : root.getChildren()) {
            Artifact artifact = node.getArtifact();
            if (!nodesKnown.contains(artifact.getId())) {
                result.add(artifact);
                this.getLog().debug((CharSequence)(offsetString + "=>" + artifact));
                this.collectChildrenArtifacts(node, result, nodesKnown);
            }
            if (!"pom".equalsIgnoreCase(artifact.getType())) continue;
            result.remove(artifact);
        }
        if ("pom".equalsIgnoreCase(root.getArtifact().getType())) {
            result.remove(root.getArtifact());
        }
        if (this.getLog().isDebugEnabled()) {
            --offset;
        }
    }

    public String expandVars(String value) {
        return StringUtils.expandVars((String)value, (Map)this.getProperties());
    }

    public void execute(AssemblyBuilder assemblyBuilder) throws MojoExecutionException {
        localLogger.set(this.getLog());
        File assemblyFile = new File(this.descriptor);
        this.resourceSets.put("*", new ProjectDependencySet(this.project, true));
        this.resourceSets.put("**", new ProjectDependencySet(this.project, false));
        try {
            this.getLog().info((CharSequence)("Loading assembly descriptor: " + this.descriptor));
            Assembly assembly = assemblyBuilder.parse(assemblyFile);
            HashMap<Object, Object> context = new HashMap<Object, Object>();
            context.putAll(this.project.getProperties());
            context.put("assemblyFile", assemblyFile);
            context.put("builder", assemblyBuilder);
            context.put("resourceSets", this.resourceSets);
            assembly.run(context);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run assembly", e);
        }
    }

    public Artifact getArtifact(Artifact artifact) {
        Artifact artifactFound = this.getArtifact(artifact.getId());
        return artifactFound != null ? artifactFound : artifact;
    }

    public Artifact getArtifact(String artifactId) {
        Artifact artifactFound = null;
        Set artifacts = this.getProject().getArtifacts();
        for (Artifact artifactTemp : artifacts) {
            if (!artifactId.equals(artifactTemp.getId())) continue;
            artifactFound = artifactTemp;
            break;
        }
        return artifactFound;
    }

    @Override
    public Properties getProperties() {
        if (this.props == null) {
            this.props = this.project.getProperties();
            this.props.put("project.version", this.project.getVersion());
            if (this.project.getBasedir() != null) {
                this.props.put("basedir", this.project.getBasedir().getPath());
            }
            this.props.put("outputDirectory", this.project.getBuild().getOutputDirectory());
            this.props.put("buildDirectory", this.project.getBuild().getDirectory());
        }
        return this.props;
    }

    public static Log getLogger() {
        return localLogger.get();
    }
}

