/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Profile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;
import org.nuxeo.build.ant.MavenEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTask
extends Sequential {
    public static final String MATCHED_PROFILES_REF = "nuxeo.matched.profiles.ref";
    public static final String ACTIVATED_PROFILES_REF = "nuxeo.activated.profiles.ref";
    protected String name;

    public void setName(String value) {
        this.name = value;
    }

    public String getProfileName() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (ProfileTask.isProfileActivated(this.getProject(), this.name)) {
            ProfileTask.getMatchedProfiles(this.getProject()).add(this.name);
            super.execute();
        }
    }

    public static boolean isProfileActivated(Project project, String name) {
        if (ProfileTask.getActivatedProfiles(project).contains(name)) {
            return true;
        }
        MavenEnvironment env = new MavenEnvironment();
        List profiles = env.getMavenProject().getActiveProfiles();
        for (Profile p : profiles) {
            if (!p.getId().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void activateProfile(Project project, String profile) {
        Set<String> ap = ProfileTask.getActivatedProfiles(project);
        ap.add(profile);
    }

    public static boolean hasMatched(Project project, String profile) {
        return ProfileTask.getMatchedProfiles(project).contains(profile);
    }

    public static Set<String> getActivatedProfiles(Project project) {
        HashSet mp = (HashSet)project.getReference(ACTIVATED_PROFILES_REF);
        if (mp == null) {
            mp = new HashSet();
            project.addReference(ACTIVATED_PROFILES_REF, mp);
        }
        return mp;
    }

    public static Set<String> getMatchedProfiles(Project project) {
        HashSet mp = (HashSet)project.getReference(MATCHED_PROFILES_REF);
        if (mp == null) {
            mp = new HashSet();
            project.addReference(MATCHED_PROFILES_REF, mp);
        }
        return mp;
    }

    public static boolean executeProfileTask(Project project, Task profileTask) {
        int last = ProfileTask.getMatchedProfiles(project).size();
        profileTask.perform();
        return last != ProfileTask.getMatchedProfiles(project).size();
    }
}

