/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.nuxeo.build.ant.ProfileTask;

public class ProfileGroupTask
extends Task
implements TaskContainer {
    protected String defaultProfile;
    protected List<Task> tasks = new ArrayList<Task>();

    public void setDefault(String value) {
        this.defaultProfile = value;
    }

    public void addTask(Task task) {
        if (!"profile".equals(task.getTaskName())) {
            throw new BuildException("Trying to insert a task which is not a profile into a profile group: " + task.getTaskName());
        }
        this.tasks.add(task);
    }

    public void execute() throws BuildException {
        Project project = this.getProject();
        for (Task task : this.tasks) {
            if (!ProfileTask.executeProfileTask(project, task)) continue;
            return;
        }
        if (this.defaultProfile != null) {
            for (Task task : this.tasks) {
                String name = (String)task.getRuntimeConfigurableWrapper().getAttributeMap().get("name");
                if (!this.defaultProfile.equals(name)) continue;
                ProfileTask.activateProfile(project, name);
                task.perform();
                return;
            }
        }
    }
}

