/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuxeo.common.utils.FileUtils;

public class DownloadMojo
extends AbstractMojo {
    private String artifact;
    private File out;
    private String repoUrl;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected ArtifactRepository local;
    protected List<ArtifactRepository> remoteArtifactRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] ar;
        if (this.repoUrl != null) {
            DefaultArtifactRepository repo = new DefaultArtifactRepository("auto-generated-repository", this.repoUrl, null);
            this.remoteArtifactRepositories.add((ArtifactRepository)repo);
        }
        if ((ar = this.artifact.split(":")).length < 3) {
            throw new MojoExecutionException("Artifact key is invalid: " + this.artifact + ". Please use the format: groupId:artifactId:version[:type][:classifier]");
        }
        String type = ar.length == 3 ? "jar" : ar[3];
        String classifier = ar.length == 5 ? ar[4] : null;
        Artifact a = null;
        a = classifier == null ? this.factory.createArtifact(ar[0], ar[1], ar[2], null, type) : this.factory.createArtifactWithClassifier(ar[0], ar[1], ar[2], type, ar[4]);
        try {
            this.resolver.resolveAlways(a, this.remoteArtifactRepositories, this.local);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Artifact not found: " + a, e);
        }
        File file = a.getFile();
        File dir = this.out.getParentFile();
        dir.mkdirs();
        try {
            FileUtils.copy((File)file, (File)this.out);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy file: " + file + " to " + this.out);
        }
        System.out.println("> downloaded to " + this.out.getAbsolutePath());
    }
}

