/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.nuxeo.build.DOMSerializer;
import org.nuxeo.build.DependencyTreeFull;
import org.nuxeo.build.Node;
import org.nuxeo.common.xmap.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DependencyTreeMojo
extends AbstractMojo {
    private MavenProject project;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private Set<String> nodesKnown;
    private String file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Context ctx = new Context();
        ctx.setProperty("mojo", (Object)this);
        ctx.setProperty("project", (Object)this.getProject());
        ctx.setProperty("builder", (Object)this.getDependencyTreeBuilder());
        ctx.setProperty("repository", (Object)this.getLocalRepository());
        ctx.setProperty("factory", (Object)this.getArtifactFactory());
        ctx.setProperty("metadataSource", (Object)this.getArtifactMetadataSource());
        ctx.setProperty("collector", (Object)this.getArtifactCollector());
        DependencyTreeFull tree = new DependencyTreeFull(ctx);
        Node root = tree.getRoot();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element element = doc.createElement("artifact");
            element.setAttribute("id", root.getArtifact().getId());
            doc.appendChild(element);
            this.buildDocument(element, root);
            if (this.file == null) {
                this.file = "dependency-tree.xml";
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.file)));
            try {
                DOMSerializer.write(doc, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("failed to export dependency tree", e);
        }
    }

    protected void buildDocument(Element parent, Node node) {
        if (this.nodesKnown == null) {
            this.nodesKnown = new HashSet<String>();
        }
        Element element = parent.getOwnerDocument().createElement("artifact");
        element.setAttribute("id", node.getArtifact().getId());
        parent.appendChild(element);
        this.nodesKnown.add(node.getArtifact().getId());
        for (Node child : node.getChildren()) {
            if (!this.nodesKnown.contains(child.getArtifact().getId())) {
                this.buildDocument(element, child);
                continue;
            }
            this.getLog().debug((CharSequence)("not exploring again " + child.getArtifact()));
            Element childElement = parent.getOwnerDocument().createElement("artifact");
            childElement.setAttribute("id", child.getArtifact().getId());
            element.appendChild(childElement);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyTreeBuilder getDependencyTreeBuilder() {
        return this.dependencyTreeBuilder;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public ArtifactCollector getArtifactCollector() {
        return this.artifactCollector;
    }
}

