/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.DependencyTree;
import org.nuxeo.build.Node;
import org.nuxeo.common.xmap.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTreeImpl
implements DependencyTree {
    protected Map<String, Node> nodes;
    protected Node root;
    protected Log log;

    public DependencyTreeImpl() {
    }

    public DependencyTreeImpl(Context ctx) {
        this.nodes = new HashMap<String, Node>();
        this.setRoot(ctx);
    }

    protected void setRoot(Context ctx) {
        MavenProject project = (MavenProject)ctx.getProperty("project");
        this.root = this.putNode(project.getArtifact());
        Set artifacts = project.getArtifacts();
        for (Artifact artifact : artifacts) {
            Node node = this.putNode(artifact);
            String parentId = node.getParentID();
            if (parentId == null) continue;
            Node parentNode = this.putNode(parentId);
            parentNode.add(node);
        }
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    protected Node putNode(String key) {
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this.nodes);
            this.nodes.put(key, node);
        }
        return node;
    }

    protected Node putNode(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        Node node = this.putNode(artifact.getId());
        node.setArtifact(artifact);
        return node;
    }

    @Override
    public Map<String, Node> getNodes() {
        return this.nodes;
    }
}

