/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.nuxeo.build.DependencyTreeImpl;
import org.nuxeo.build.Node;
import org.nuxeo.build.assembler.AbstractNuxeoAssembler;
import org.nuxeo.common.xmap.Context;

public class DependencyTreeFull
extends DependencyTreeImpl {
    public DependencyTreeFull(Context ctx) {
        this.nodes = new HashMap();
        this.log = AbstractNuxeoAssembler.getLogger();
        this.setRoot(ctx);
    }

    protected void setRoot(Context ctx) {
        DependencyNode rootDependencyNode = null;
        try {
            DependencyTreeBuilder dependencyTreeBuilder = (DependencyTreeBuilder)ctx.getProperty("builder");
            rootDependencyNode = dependencyTreeBuilder.buildDependencyTree((MavenProject)ctx.getProperty("project"), (ArtifactRepository)ctx.getProperty("repository"), (ArtifactFactory)ctx.getProperty("factory"), (ArtifactMetadataSource)ctx.getProperty("metadataSource"), null, (ArtifactCollector)ctx.getProperty("collector"));
        }
        catch (DependencyTreeBuilderException e) {
            this.log.error((CharSequence)"Cannot build project dependency tree", (Throwable)e);
        }
        this.root = this.putNode(rootDependencyNode);
    }

    private Node putNode(DependencyNode dependencyNode) {
        Node node;
        if (dependencyNode == null) {
            return null;
        }
        Artifact artifact = dependencyNode.getArtifact();
        Node existingNode = (Node)this.nodes.get(artifact.getId());
        if (existingNode != null) {
            node = existingNode;
        } else {
            node = new Node(this.nodes, artifact);
            this.nodes.put(artifact.getId(), node);
        }
        Iterator childrenIterator = dependencyNode.iterator();
        Artifact artifactItself = ((DependencyNode)childrenIterator.next()).getArtifact();
        if (!artifactItself.getId().equals(artifact.getId())) {
            this.log.error((CharSequence)("first child " + artifactItself + " different from artifact " + artifact));
        }
        while (childrenIterator.hasNext()) {
            DependencyNode childNode = (DependencyNode)childrenIterator.next();
            node.add(this.putNode(childNode));
        }
        return node;
    }
}

