/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.SessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class EnforcerRuleCache {
    private final Logger logger = LoggerFactory.getLogger(EnforcerRuleCache.class);
    private final Provider<MavenSession> sessionProvider;

    @Inject
    EnforcerRuleCache(Provider<MavenSession> sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(AbstractEnforcerRule rule) {
        String cacheId = rule.getCacheId();
        if (cacheId == null) {
            return false;
        }
        Class<?> ruleClass = rule.getClass();
        this.logger.debug("Check cache for {} with id {}", ruleClass, (Object)cacheId);
        SessionData sessionData = ((MavenSession)this.sessionProvider.get()).getRepositorySession().getData();
        EnforcerRuleCache enforcerRuleCache = this;
        synchronized (enforcerRuleCache) {
            List cacheIdList;
            HashMap<Class, List> cache = (HashMap<Class, List>)sessionData.get((Object)"enforcer-cache");
            if (cache == null) {
                cache = new HashMap<Class, List>();
                sessionData.set((Object)"enforcer-cache", cache);
            }
            if ((cacheIdList = cache.computeIfAbsent(ruleClass, k -> new ArrayList())).contains(cacheId)) {
                this.logger.debug("Already cached {} with id {}", ruleClass, (Object)cacheId);
                return true;
            }
            this.logger.debug("Add cache {} with id {}", ruleClass, (Object)cacheId);
            cacheIdList.add(cacheId);
        }
        return false;
    }
}

