/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ResolveFileFilter;
import org.apache.maven.plugins.dependency.utils.markers.SourcesFileMarkerHandler;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolveDependenciesMojo
extends AbstractResolveMojo {
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="mdep.outputScope", defaultValue="true")
    protected boolean outputScope;
    DependencyStatusSets results;
    @Parameter(property="sort", defaultValue="false")
    boolean sort;
    @Parameter(property="includeParents", defaultValue="false")
    boolean includeParents;

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.results = this.getDependencySets(false, this.includeParents);
        String output = this.getOutput(this.outputAbsoluteArtifactFilename, this.outputScope, this.sort);
        try {
            if (this.outputFile == null) {
                DependencyUtil.log(output, this.getLog());
            } else {
                String encoding = Objects.toString(this.outputEncoding, "UTF-8");
                DependencyUtil.write(output, this.outputFile, this.appendOutput, encoding);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public DependencyStatusSets getResults() {
        return this.results;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ResolveFileFilter(new SourcesFileMarkerHandler(this.markersDirectory));
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean theOutputScope, boolean theSort) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("The following files have been resolved:");
        sb.append(System.lineSeparator());
        if (this.results.getResolvedDependencies() == null || this.results.getResolvedDependencies().isEmpty()) {
            sb.append("   none");
            sb.append(System.lineSeparator());
        } else {
            sb.append((CharSequence)this.buildArtifactListOutput(this.results.getResolvedDependencies(), outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        if (this.results.getSkippedDependencies() != null && !this.results.getSkippedDependencies().isEmpty()) {
            sb.append(System.lineSeparator());
            sb.append("The following files were skipped:");
            sb.append(System.lineSeparator());
            LinkedHashSet<Artifact> skippedDependencies = new LinkedHashSet<Artifact>(this.results.getSkippedDependencies());
            sb.append((CharSequence)this.buildArtifactListOutput(skippedDependencies, outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        if (this.results.getUnResolvedDependencies() != null && !this.results.getUnResolvedDependencies().isEmpty()) {
            sb.append(System.lineSeparator());
            sb.append("The following files have NOT been resolved:");
            sb.append(System.lineSeparator());
            LinkedHashSet<Artifact> unResolvedDependencies = new LinkedHashSet<Artifact>(this.results.getUnResolvedDependencies());
            sb.append((CharSequence)this.buildArtifactListOutput(unResolvedDependencies, outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private StringBuilder buildArtifactListOutput(Set<Artifact> artifacts, boolean outputAbsoluteArtifactFilename, boolean theOutputScope, boolean theSort) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> artifactStringList = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            ModuleDescriptor moduleDescriptor;
            MessageBuilder messageBuilder = MessageUtils.buffer();
            messageBuilder.a((CharSequence)"   ");
            if (theOutputScope) {
                messageBuilder.a((CharSequence)artifact.toString());
            } else {
                messageBuilder.a((CharSequence)artifact.getId());
            }
            if (outputAbsoluteArtifactFilename) {
                try {
                    String artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                    messageBuilder.a((Object)Character.valueOf(':')).a((CharSequence)artifactFilename);
                }
                catch (NullPointerException artifactFilename) {
                    // empty catch block
                }
            }
            if (theOutputScope && artifact.isOptional()) {
                messageBuilder.a((CharSequence)" (optional)");
            }
            if (artifact.getFile() != null && (moduleDescriptor = this.getModuleDescriptor(artifact.getFile())) != null) {
                messageBuilder.project((Object)(" -- module " + moduleDescriptor.name));
                if (moduleDescriptor.automatic) {
                    if ("MANIFEST".equals(moduleDescriptor.moduleNameSource)) {
                        messageBuilder.strong((Object)" [auto]");
                    } else {
                        messageBuilder.warning((Object)" (auto)");
                    }
                }
            }
            artifactStringList.add(messageBuilder + System.lineSeparator());
        }
        if (theSort) {
            Collections.sort(artifactStringList);
        }
        for (String artifactString : artifactStringList) {
            sb.append(artifactString);
        }
        return sb;
    }

    private ModuleDescriptor getModuleDescriptor(File artifactFile) {
        ModuleDescriptor moduleDescriptor;
        block19: {
            moduleDescriptor = null;
            try {
                Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
                Path path = artifactFile.toPath();
                Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
                Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{path}});
                Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
                Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
                if (moduleReferences.isEmpty()) break block19;
                Object moduleReference = moduleReferences.iterator().next();
                Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
                Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
                Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
                moduleDescriptor = new ModuleDescriptor();
                moduleDescriptor.name = name;
                Method isAutomaticMethod = moduleDescriptorInstance.getClass().getMethod("isAutomatic", new Class[0]);
                moduleDescriptor.automatic = (Boolean)isAutomaticMethod.invoke(moduleDescriptorInstance, new Object[0]);
                if (!moduleDescriptor.automatic || !artifactFile.isFile()) break block19;
                try (JarFile jarFile = new JarFile(artifactFile);){
                    Manifest manifest = jarFile.getManifest();
                    moduleDescriptor.moduleNameSource = manifest != null && manifest.getMainAttributes().getValue("Automatic-Module-Name") != null ? "MANIFEST" : "FILENAME";
                }
                catch (IOException iOException) {}
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException moduleFinderClass) {
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                this.getLog().info((CharSequence)("Can't extract module name from " + artifactFile.getName() + ": " + cause.getMessage()));
            }
        }
        return moduleDescriptor;
    }

    private class ModuleDescriptor {
        String name;
        boolean automatic = true;
        String moduleNameSource;

        private ModuleDescriptor() {
        }
    }
}

