/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.io.File;
import org.apache.maven.plugins.assembly.io.FileLocation;
import org.apache.maven.plugins.assembly.io.Location;
import org.apache.maven.plugins.assembly.io.LocatorStrategy;
import org.apache.maven.plugins.assembly.io.MessageHolder;

class RelativeFileLocatorStrategy
implements LocatorStrategy {
    private final File basedir;

    RelativeFileLocatorStrategy(File basedir) {
        this.basedir = basedir;
    }

    @Override
    public Location resolve(String locationSpecification, MessageHolder messageHolder) {
        File file = new File(this.basedir, locationSpecification);
        messageHolder.addInfoMessage("Searching for file location: " + file.getAbsolutePath());
        FileLocation location = null;
        if (file.exists()) {
            location = new FileLocation(file, locationSpecification);
        } else {
            messageHolder.addMessage("File: " + file.getAbsolutePath() + " does not exist.");
        }
        return location;
    }
}

