/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class MessageLevels {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_SEVERE = 4;
    public static final int LEVEL_DISABLED = 5;
    private static final List<String> LEVEL_NAMES;

    private MessageLevels() {
    }

    static boolean[] getLevelStates(int maxMessageLevel) {
        boolean[] states = new boolean[5];
        Arrays.fill(states, false);
        switch (maxMessageLevel) {
            case 0: {
                states[0] = true;
            }
            case 1: {
                states[1] = true;
            }
            case 2: {
                states[2] = true;
            }
            case 3: {
                states[3] = true;
            }
            case 4: {
                states[4] = true;
            }
        }
        return states;
    }

    static String getLevelLabel(int messageLevel) {
        if (messageLevel > -1 && LEVEL_NAMES.size() > messageLevel) {
            return LEVEL_NAMES.get(messageLevel);
        }
        throw new IllegalArgumentException("Invalid message level: " + messageLevel);
    }

    static {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DEBUG");
        names.add("INFO");
        names.add("WARN");
        names.add("ERROR");
        names.add("SEVERE");
        LEVEL_NAMES = Collections.unmodifiableList(names);
    }
}

