/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.AbstractBuildinfoMojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

@Mojo(name="check-buildplan", threadSafe=true, requiresProject=true)
public class CheckBuildPlanMojo
extends AbstractMojo {
    private final MavenProject project;
    private final MavenSession session;
    private final LifecycleExecutor lifecycleExecutor;
    @Parameter(property="check.buildplan.tasks", defaultValue="deploy")
    private String[] tasks;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(property="diagnose", defaultValue="false")
    private boolean diagnose;
    @Parameter(property="check.plugin-issues")
    private File pluginIssues;
    @Parameter(property="check.failOnNonReproducible", defaultValue="true")
    private boolean failOnNonReproducible;
    private final VersionScheme versionScheme = new GenericVersionScheme();

    @Inject
    public CheckBuildPlanMojo(MavenProject project, MavenSession session, LifecycleExecutor lifecycleExecutor) {
        this.project = project;
        this.session = session;
        this.lifecycleExecutor = lifecycleExecutor;
    }

    protected MavenExecutionPlan calculateExecutionPlan() throws MojoExecutionException {
        try {
            return this.lifecycleExecutor.calculateExecutionPlan(this.session, this.tasks);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot calculate Maven execution plan" + e.getMessage(), e);
        }
    }

    public void execute() throws MojoExecutionException {
        boolean fail = AbstractBuildinfoMojo.hasBadOutputTimestamp(this.outputTimestamp, this.getLog(), this.project, this.session, this.diagnose);
        Properties issues = this.loadIssues();
        MavenExecutionPlan plan = this.calculateExecutionPlan();
        HashSet<String> plugins = new HashSet<String>();
        int okCount = 0;
        for (MojoExecution exec : plan.getMojoExecutions()) {
            Plugin plugin = exec.getPlugin();
            String id = plugin.getId();
            if (!plugins.add(id)) continue;
            String issue = issues.getProperty(plugin.getKey());
            if (issue == null) {
                ++okCount;
                this.getLog().debug((CharSequence)("No known issue with " + id));
                continue;
            }
            if (issue.startsWith("fail:")) {
                String logMessage = "plugin without solution " + id + ", see " + issue.substring(5);
                if (this.failOnNonReproducible) {
                    this.getLog().error((CharSequence)logMessage);
                } else {
                    this.getLog().warn((CharSequence)logMessage);
                }
                fail = true;
                continue;
            }
            try {
                Version minimum = this.versionScheme.parseVersion(issue);
                Version version = this.versionScheme.parseVersion(plugin.getVersion());
                if (version.compareTo((Object)minimum) < 0) {
                    String logMessage = "plugin with non-reproducible output: " + id + ", require minimum " + issue;
                    if (this.failOnNonReproducible) {
                        this.getLog().error((CharSequence)logMessage);
                    } else {
                        this.getLog().warn((CharSequence)logMessage);
                    }
                    fail = true;
                    continue;
                }
                ++okCount;
                this.getLog().debug((CharSequence)("No known issue with " + id + " (>= " + issue + ")"));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
        if (okCount > 0) {
            this.getLog().info((CharSequence)("No known issue in " + okCount + " plugins"));
        }
        if (fail) {
            this.getLog().info((CharSequence)("current module pom.xml is " + this.project.getBasedir() + "/pom.xml"));
            MavenProject parent = this.project;
            while ((parent = parent.getParent()) != null && this.session.getProjects().contains(parent)) {
                this.getLog().info((CharSequence)("        parent pom.xml is " + parent.getBasedir() + "/pom.xml"));
            }
            String message = "non-reproducible plugin or configuration found with fix available";
            if (this.failOnNonReproducible) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }

    private Properties loadIssues() throws MojoExecutionException {
        Properties properties;
        block10: {
            InputStream in = this.pluginIssues == null ? ((Object)((Object)this)).getClass().getResourceAsStream("not-reproducible-plugins.properties") : Files.newInputStream(this.pluginIssues.toPath(), new OpenOption[0]);
            try {
                Properties prop = new Properties();
                prop.load(in);
                Properties result = new Properties();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String plugin = entry.getKey().toString().replace('+', ':');
                    if (!plugin.contains(":")) {
                        plugin = "org.apache.maven.plugins:" + plugin;
                    }
                    result.put(plugin, entry.getValue());
                }
                properties = result;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Cannot load issues file", (Exception)ioe);
                }
            }
            in.close();
        }
        return properties;
    }
}

