/*
 * $Id$
 */

package org.apache.maven.settings;

/**
 * 
 *         
 *         The <code>&lt;server&gt;</code> element contains
 * informations required to a server settings.
 *         
 * 
 * @version $Revision$ $Date$
 */
public class Server extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field username
     */
    private String username;

    /**
     * Field password
     */
    private String password;

    /**
     * Field privateKey
     */
    private String privateKey;

    /**
     * Field passphrase
     */
    private String passphrase;

    /**
     * Field filePermissions
     */
    private String filePermissions;

    /**
     * Field directoryPermissions
     */
    private String directoryPermissions;

    /**
     * Field configuration
     */
    private Object configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             
     *             Extra configuration for the transport layer.
     *             
     *           
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get 
     *             
     *             The permissions for directories when they are
     * created.
     *             
     *           
     */
    public String getDirectoryPermissions()
    {
        return this.directoryPermissions;
    } //-- String getDirectoryPermissions() 

    /**
     * Get 
     *             
     *             The permissions for files when they are created.
     *             
     *           
     */
    public String getFilePermissions()
    {
        return this.filePermissions;
    } //-- String getFilePermissions() 

    /**
     * Get 
     *             
     *             The passphrase used in conjunction with the
     * privateKey to authenticate.
     *             
     *           
     */
    public String getPassphrase()
    {
        return this.passphrase;
    } //-- String getPassphrase() 

    /**
     * Get 
     *             
     *             The password used in conjunction with the
     * username to authenticate.
     *             
     *           
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Get 
     *             
     *             The private key location used to authenticate.
     *             
     *           
     */
    public String getPrivateKey()
    {
        return this.privateKey;
    } //-- String getPrivateKey() 

    /**
     * Get 
     *             
     *             The username used to authenticate.
     *             
     *           
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Set 
     *             
     *             Extra configuration for the transport layer.
     *             
     *           
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Set 
     *             
     *             The permissions for directories when they are
     * created.
     *             
     *           
     * 
     * @param directoryPermissions
     */
    public void setDirectoryPermissions(String directoryPermissions)
    {
        this.directoryPermissions = directoryPermissions;
    } //-- void setDirectoryPermissions(String) 

    /**
     * Set 
     *             
     *             The permissions for files when they are created.
     *             
     *           
     * 
     * @param filePermissions
     */
    public void setFilePermissions(String filePermissions)
    {
        this.filePermissions = filePermissions;
    } //-- void setFilePermissions(String) 

    /**
     * Set 
     *             
     *             The passphrase used in conjunction with the
     * privateKey to authenticate.
     *             
     *           
     * 
     * @param passphrase
     */
    public void setPassphrase(String passphrase)
    {
        this.passphrase = passphrase;
    } //-- void setPassphrase(String) 

    /**
     * Set 
     *             
     *             The password used in conjunction with the
     * username to authenticate.
     *             
     *           
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set 
     *             
     *             The private key location used to authenticate.
     *             
     *           
     * 
     * @param privateKey
     */
    public void setPrivateKey(String privateKey)
    {
        this.privateKey = privateKey;
    } //-- void setPrivateKey(String) 

    /**
     * Set 
     *             
     *             The username used to authenticate.
     *             
     *           
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
