/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContainer
implements Serializable,
Cloneable {
    private List<Plugin> plugins;
    Map<String, Plugin> pluginMap;

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public PluginContainer clone() {
        try {
            PluginContainer copy = (PluginContainer)super.clone();
            if (this.plugins != null) {
                copy.plugins = new ArrayList<Plugin>();
                for (Plugin item : this.plugins) {
                    copy.plugins.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public void removePlugin(Plugin plugin) {
        this.getPlugins().remove(plugin);
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public synchronized void flushPluginMap() {
        this.pluginMap = null;
    }

    public synchronized Map<String, Plugin> getPluginsAsMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new LinkedHashMap<String, Plugin>();
            if (this.plugins != null) {
                for (Plugin plugin : this.plugins) {
                    this.pluginMap.put(plugin.getKey(), plugin);
                }
            }
        }
        return this.pluginMap;
    }
}

