/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.util.Arrays;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class BuildHelper {
    public static String discoverJavaRelease(MavenProject project) {
        Plugin compiler = BuildHelper.getCompilerPlugin(project);
        String jdk = BuildHelper.getPluginParameter(project, compiler, "release", "maven.compiler.release");
        if (jdk == null) {
            jdk = BuildHelper.getPluginParameter(project, compiler, "target", "maven.compiler.target");
        }
        return BuildHelper.normalizeJavaVersion(jdk);
    }

    public static String normalizeJavaVersion(String jdk) {
        if (jdk != null && jdk.length() == 3 && Arrays.asList("1.5", "1.6", "1.7", "1.8").contains(jdk)) {
            jdk = jdk.substring(2);
        }
        return jdk;
    }

    public static Plugin getCompilerPlugin(MavenProject project) {
        return BuildHelper.getPlugin(project, "org.apache.maven.plugins:maven-compiler-plugin");
    }

    public static Plugin getPlugin(MavenProject project, String pluginGa) {
        Plugin plugin = BuildHelper.getPlugin((PluginContainer)project.getBuild(), pluginGa);
        if (plugin == null) {
            plugin = BuildHelper.getPlugin((PluginContainer)project.getPluginManagement(), pluginGa);
        }
        return plugin;
    }

    public static String getPluginParameter(MavenProject project, Plugin plugin, String parameter, String defaultValueProperty) {
        String value = BuildHelper.getPluginParameter(plugin, parameter);
        if (value == null) {
            value = project.getProperties().getProperty(defaultValueProperty);
        }
        return value;
    }

    private static Plugin getPlugin(PluginContainer container, String pluginGa) {
        if (container == null) {
            return null;
        }
        Map pluginsAsMap = container.getPluginsAsMap();
        return (Plugin)pluginsAsMap.get(pluginGa);
    }

    private static String getPluginParameter(Plugin plugin, String parameter) {
        Xpp3Dom target;
        Xpp3Dom pluginConf;
        if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
            return target.getValue();
        }
        return null;
    }
}

