/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class IssueManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final Map<Object, InputLocation> locations;

    IssueManagement(String system, String url, Map<Object, InputLocation> locations) {
        this.system = system;
        this.url = url;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return IssueManagement.newBuilder(this);
    }

    @Nonnull
    public IssueManagement withSystem(String system) {
        return IssueManagement.newBuilder(this, true).system(system).build();
    }

    @Nonnull
    public IssueManagement withUrl(String url) {
        return IssueManagement.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public static IssueManagement newInstance() {
        return IssueManagement.newInstance(true);
    }

    @Nonnull
    public static IssueManagement newInstance(boolean withDefaults) {
        return IssueManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return IssueManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from) {
        return IssueManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "IssueManagement {system=" + this.getSystem() + ", url=" + this.getUrl() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        IssueManagement base;
        String system;
        String url;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(IssueManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public IssueManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("system", newlocs.containsKey("system") ? (InputLocation)newlocs.get("system") : (InputLocation)oldlocs.get("system"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            return new IssueManagement(this.system != null ? this.system : (this.base != null ? this.base.system : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), locations);
        }
    }
}

