/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlUtil;

public class XmlWriterXdocSink
extends XdocSink {
    private StringWriter xdocWriter;
    private XMLWriter xmlWriter;

    private XmlWriterXdocSink(StringWriter out, String encoding) {
        super(out, encoding);
        this.xdocWriter = out;
        this.xmlWriter = new PrettyPrintXMLWriter((Writer)out);
    }

    public XmlWriterXdocSink(XMLWriter out) {
        this(new StringWriter(), "UTF-8");
        this.xmlWriter = out;
    }

    @Override
    public void close() {
        super.close();
        String xdocContent = this.xdocWriter.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Xdoc content: " + xdocContent));
        }
        StringWriter formattedContent = new StringWriter();
        try {
            XmlUtil.prettyFormat((Reader)new StringReader(xdocContent), (Writer)formattedContent);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
            formattedContent = new StringWriter();
            formattedContent.write(xdocContent);
        }
        this.xmlWriter.writeMarkup(formattedContent.toString());
    }
}

