/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.lookup.HBaseLookupRowEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupTable
implements ILookupTable {
    protected static final Logger logger = LoggerFactory.getLogger(HBaseLookupTable.class);
    private TableName lookupTableName;
    private Table table;
    private HBaseLookupRowEncoder encoder;

    public HBaseLookupTable(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshot) {
        String tableName = extTableSnapshot.getStorageLocationIdentifier();
        this.lookupTableName = TableName.valueOf((String)tableName);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Connection connection = HBaseConnection.get(kylinConfig.getStorageUrl());
        try {
            this.table = connection.getTable(this.lookupTableName);
        }
        catch (IOException e) {
            throw new RuntimeException("error when connect HBase", e);
        }
        String[] keyColumns = extTableSnapshot.getKeyColumns();
        this.encoder = new HBaseLookupRowEncoder(tableDesc, keyColumns, extTableSnapshot.getShardNum());
    }

    public String[] getRow(Array<String> key) {
        byte[] encodedKey = this.encoder.encodeRowKey((String[])key.getData());
        Get get = new Get(encodedKey);
        try {
            Result result = this.table.get(get);
            if (result.isEmpty()) {
                return null;
            }
            return this.encoder.decode(new HBaseLookupRowEncoder.HBaseRow(result.getRow(), result.getFamilyMap(HBaseLookupRowEncoder.CF)));
        }
        catch (IOException e) {
            throw new RuntimeException("error when get row from hBase", e);
        }
    }

    public Iterator<String[]> iterator() {
        return new HBaseScanBasedIterator(this.table);
    }

    public void close() throws IOException {
        this.table.close();
    }

    private class HBaseScanBasedIterator
    implements Iterator<String[]> {
        private Iterator<Result> scannerIterator;
        private long counter;

        public HBaseScanBasedIterator(Table table) {
            try {
                Scan scan = new Scan();
                scan.setCaching(1000);
                ResultScanner scanner = table.getScanner(HBaseLookupRowEncoder.CF);
                this.scannerIterator = scanner.iterator();
            }
            catch (IOException e) {
                logger.error("error when scan HBase", (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.scannerIterator.hasNext();
        }

        @Override
        public String[] next() {
            ++this.counter;
            if (this.counter % 100000L == 0L) {
                logger.info("scanned {} rows from hBase", (Object)this.counter);
            }
            Result result = this.scannerIterator.next();
            byte[] rowKey = result.getRow();
            NavigableMap qualifierValMap = result.getFamilyMap(HBaseLookupRowEncoder.CF);
            return HBaseLookupTable.this.encoder.decode(new HBaseLookupRowEncoder.HBaseRow(rowKey, qualifierValMap));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

