/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.dict.lookup.AbstractLookupRowEncoder;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class HBaseLookupRowEncoder
extends AbstractLookupRowEncoder<HBaseRow> {
    public static final String CF_STRING = "F";
    public static final byte[] CF = Bytes.toBytes((String)"F");
    private int shardNum;

    public HBaseLookupRowEncoder(TableDesc tableDesc, String[] keyColumns, int shardNum) {
        super(tableDesc, keyColumns);
        this.shardNum = shardNum;
    }

    public HBaseRow encode(String[] row) {
        String[] keys = this.getKeyData(row);
        String[] values = this.getValueData(row);
        byte[] rowKey = this.encodeRowKey(keys);
        TreeMap qualifierValMap = Maps.newTreeMap((Comparator)org.apache.hadoop.hbase.util.Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < values.length; ++i) {
            byte[] qualifier = Bytes.toBytes((String)String.valueOf(this.valueIndexes[i]));
            byte[] byteValue = this.toBytes(values[i]);
            qualifierValMap.put(qualifier, byteValue);
        }
        return new HBaseRow(rowKey, qualifierValMap);
    }

    public String[] decode(HBaseRow hBaseRow) {
        if (hBaseRow == null) {
            return null;
        }
        String[] result = new String[this.columnsNum];
        this.fillKeys(hBaseRow.rowKey, result);
        this.fillValues(hBaseRow.qualifierValMap, result);
        return result;
    }

    public byte[] encodeRowKey(String[] keys) {
        this.keyByteBuffer.clear();
        for (String key : keys) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null:" + Arrays.toString(keys));
            }
            byte[] byteKey = Bytes.toBytes((String)key);
            this.keyByteBuffer.putShort((short)byteKey.length);
            this.keyByteBuffer.put(byteKey);
        }
        byte[] result = new byte[2 + this.keyByteBuffer.position()];
        System.arraycopy(this.keyByteBuffer.array(), 0, result, 2, this.keyByteBuffer.position());
        short shard = ShardingHash.getShard((byte[])result, (int)2, (int)(result.length - 2), (int)this.shardNum);
        BytesUtil.writeShort((short)shard, (byte[])result, (int)0, (int)2);
        return result;
    }

    private void fillKeys(byte[] rowKey, String[] result) {
        int keyNum = this.keyIndexes.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(rowKey);
        byteBuffer.getShort();
        for (int i = 0; i < keyNum; ++i) {
            short keyLen = byteBuffer.getShort();
            byte[] keyBytes = new byte[keyLen];
            byteBuffer.get(keyBytes);
            result[this.keyIndexes[i]] = Bytes.toString((byte[])keyBytes);
        }
    }

    private void fillValues(Map<byte[], byte[]> qualifierValMap, String[] result) {
        for (Map.Entry<byte[], byte[]> qualifierValEntry : qualifierValMap.entrySet()) {
            byte[] qualifier = qualifierValEntry.getKey();
            byte[] value = qualifierValEntry.getValue();
            int valIdx = Integer.parseInt(Bytes.toString((byte[])qualifier));
            result[valIdx] = this.fromBytes(value);
        }
    }

    public static class HBaseRow {
        private byte[] rowKey;
        private NavigableMap<byte[], byte[]> qualifierValMap;

        public HBaseRow(byte[] rowKey, NavigableMap<byte[], byte[]> qualifierValMap) {
            this.rowKey = rowKey;
            this.qualifierValMap = qualifierValMap;
        }

        public byte[] getRowKey() {
            return this.rowKey;
        }

        public NavigableMap<byte[], byte[]> getQualifierValMap() {
            return this.qualifierValMap;
        }
    }
}

