/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.IExtLookupProvider;
import org.apache.kylin.dict.lookup.IExtLookupTableCache;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.cache.RocksDBLookupTableCache;
import org.apache.kylin.engine.mr.ILookupMaterializer;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.storage.hbase.lookup.HBaseLookupMaterializer;
import org.apache.kylin.storage.hbase.lookup.HBaseLookupTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseLookupProvider
implements IExtLookupProvider {
    protected static final Logger logger = LoggerFactory.getLogger(HBaseLookupProvider.class);

    public ILookupTable getLookupTable(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshot) {
        return new HBaseLookupTable(tableDesc, extTableSnapshot);
    }

    public IExtLookupTableCache getLocalCache() {
        return RocksDBLookupTableCache.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == ILookupMaterializer.class) {
            return (I)new HBaseLookupMaterializer();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }
}

