/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class AggrKey
implements Comparable<AggrKey> {
    final byte[] groupByMask;
    final transient int[] groupByMaskSet;
    transient int hashcode;
    byte[] data;
    int offset;

    AggrKey(byte[] groupByMask) {
        int i;
        this.groupByMask = groupByMask;
        LinkedList list = Lists.newLinkedList();
        for (i = 0; i < groupByMask.length; ++i) {
            if (groupByMask[i] == 0) continue;
            list.add(i);
        }
        this.groupByMaskSet = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.groupByMaskSet[i] = (Integer)list.get(i);
        }
    }

    private AggrKey(byte[] groupByMask, int[] groupByMaskSet, byte[] data, int offset, int hashcode) {
        this.groupByMask = groupByMask;
        this.groupByMaskSet = groupByMaskSet;
        this.data = data;
        this.offset = offset;
        this.hashcode = hashcode;
    }

    private int calculateHash() {
        int hash = 1;
        for (int i = 0; i < this.groupByMaskSet.length; ++i) {
            byte t = this.data[this.offset + this.groupByMaskSet[i]];
            if (t == 9) continue;
            hash = 31 * hash + t;
        }
        return hash;
    }

    public byte[] get() {
        return this.data;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.groupByMask.length;
    }

    void set(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
        this.hashcode = this.calculateHash();
    }

    public byte[] getGroupByMask() {
        return this.groupByMask;
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length());
    }

    AggrKey copy() {
        AggrKey copy = new AggrKey(this.groupByMask, this.groupByMaskSet, this.copyBytes(), 0, this.hashcode);
        return copy;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggrKey other = (AggrKey)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(AggrKey o) {
        int comp = this.length() - o.length();
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.groupByMaskSet.length; ++i) {
            comp = BytesUtil.compareByteUnsigned((byte)this.data[this.offset + this.groupByMaskSet[i]], (byte)o.data[o.offset + this.groupByMaskSet[i]]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

