/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfigManager;
import kafka.server.IpConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-BQ!\u000f\u0001\u0005\u0002iBQ\u0001\u0014\u0001\u0005\u0002iBQA\u0014\u0001\u0005\n=CQa\u0019\u0001\u0005\u0002iBQ!\u001a\u0001\u0005\u0002iBQa\u001a\u0001\u0005\u0002iBQ!\u001b\u0001\u0005\u0002iBQa\u001b\u0001\u0005\u0002iBQ!\u001c\u0001\u0005\u0002iBQa\u001c\u0001\u0005\u0002iBQ!\u001d\u0001\u0005\u0002iBQa\u001d\u0001\u0005\u0002iBQ!\u001e\u0001\u0005\u0002iBQa\u001e\u0001\u0005\u0002iBQ!\u001f\u0001\u0005\u0002iBQa\u001f\u0001\u0005\u0002iBQ! \u0001\u0005\u0002iBQa \u0001\u0005\u0002iBa!a\u0001\u0001\t\u0003Q\u0004BBA\u0004\u0001\u0011\u0005!\bC\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\t9B)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKR+7\u000f\u001e\u0006\u00037q\taa]3sm\u0016\u0014(\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003Gq\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QE\t\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\u0006E\u0002.iYj\u0011A\f\u0006\u0003_A\n\u0011\"[7nkR\f'\r\\3\u000b\u0005E\u0012\u0014AC2pY2,7\r^5p]*\t1'A\u0003tG\u0006d\u0017-\u0003\u00026]\t!A*[:u!\tIs'\u0003\u000295\tY1*\u00194lC\u000e{gNZ5h\u0003A!Xm\u001d;D_:4\u0017nZ\"iC:<W\rF\u0001<!\taT(D\u00013\u0013\tq$G\u0001\u0003V]&$\bFA\u0002A!\t\t%*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011q\tS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0013%\u0001\u0002+fgR\fA\u0004^3ti\u0012Kh.Y7jGR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u0005\u0001\u0006)B/Z:u#V|G/Y\"p]\u001aLwm\u00115b]\u001e,G#B\u001eQ;~\u000b\u0007\"B)\u0006\u0001\u0004\u0011\u0016\u0001B;tKJ\u0004\"a\u0015.\u000f\u0005QC\u0006CA+3\u001b\u00051&BA,\u001f\u0003\u0019a$o\\8u}%\u0011\u0011LM\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Ze!)a,\u0002a\u0001%\u0006A1\r\\5f]RLE\rC\u0003a\u000b\u0001\u0007!+\u0001\bs_>$XI\u001c;jif$\u0016\u0010]3\t\u000b\t,\u0001\u0019\u0001*\u0002!\r|gNZ5h\u000b:$\u0018\u000e^=OC6,\u0017!\b;fgR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0019\u0001\u0015!\u0007;fgR,6/\u001a:Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#a\u0002!\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4fQ\tA\u0001)\u0001\u0013uKN$H)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tI\u0001)\u0001\u0011uKN$H)\u001a4bk2$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0006A\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tY\u0001)A\fuKN$\u0018+^8uC&s\u0017\u000e^5bY&T\u0018\r^5p]\"\u0012A\u0002Q\u0001!i\u0016\u001cH/\u00139IC:$G.\u001a:V]J,7o\u001c7wC\ndW-\u00113ee\u0016\u001c8\u000f\u000b\u0002\u000e\u0001\u0006IB/Z:u\u0013B\fVo\u001c;b\u0013:LG/[1mSj\fG/[8oQ\tq\u0001)A\fuKN$\u0018\n])v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012q\u0002Q\u0001#i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0005A\u0001\u0015!\r;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u001f:tuN\\#ySN$\u0018N\\4U_BL7mV5uQ\u0006#W.\u001b8DY&,g\u000e\u001e\u0015\u0003#\u0001\u000bq\u0003^3tiB\u0013xnY3tg:{G/\u001b4jG\u0006$\u0018n\u001c8)\u0005I\u0001\u0015!J:i_VdG\rU1sg\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t\u0019\u0002)A\u0017tQ>,H\u000e\u001a)beN,w+\u001b7eG\u0006\u0014HMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#\u0001\u0006!\u0002AMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b%\u0016\u001cX\r\u001e\u0015\u0003+\u0001\u000bQf\u001d5pk2$\u0007+\u0019:tKJ+w-\u0019:eY\u0016\u001c8o\u00144XQ&$Xm\u001d9bG\u0016\f%o\\;oIZ\u000bG.^3tQ\t1\u0002)A\u0003qCJ\u001cX\r\u0006\u0004\u0002\u0010\u0005u\u0011q\u0005\t\u0007\u0003#\t\u0019\"a\u0006\u000e\u0003AJ1!!\u00061\u0005\r\u0019V-\u001d\t\u0004y\u0005e\u0011bAA\u000ee\t\u0019\u0011J\u001c;\t\u000f\u0005}q\u00031\u0001\u0002\"\u0005i1m\u001c8gS\u001eD\u0015M\u001c3mKJ\u00042!KA\u0012\u0013\r\t)C\u0007\u0002\u0013)>\u0004\u0018nY\"p]\u001aLw\rS1oI2,'\u000f\u0003\u0004\u0002*]\u0001\rAU\u0001\u0006m\u0006dW/Z\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCAA\u0018!\u0011\t\t$!\u0011\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tQ!\u00193nS:TA!!\u000f\u0002<\u000591\r\\5f]R\u001c(bA\u000f\u0002>)\u0019\u0011q\b%\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019%a\r\u0003\u000b\u0005#W.\u001b8")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        Object[] objectArray = new KafkaConfig[1];
        objectArray[0] = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()), (String)"Should contain a ConfigHandler for topics");
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var17_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_12 = null;
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var18_18 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var20_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var8_5 = null;
        Object var13_11 = null;
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(tp, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize));
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var21_22 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var14_17 = null;
        Object var19_21 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), Integer.toString(i), 30000, 20000));
        Assertions.assertTrue((boolean)log.logSegments().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType), (String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString());
        Properties props = new Properties();
        props.put("producer_byte_rate", "1000");
        props.put("consumer_byte_rate", "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = ConfigType$.MODULE$.Client();
        if (!(string != null ? !string.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string2;
                    String string3 = string2 = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string2 = null;
                    String msgWithLogIdent_msg = string3;
                    Object var24_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var12_8 = null;
        Object var17_12 = null;
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = ConfigType$.MODULE$.Client();
        if (!(string4 != null ? !string4.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string5;
                    String string6 = string5 = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string5 = null;
                    String msgWithLogIdent_msg = string6;
                    Object var25_23 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void testIpQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        server.shutdown();
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        ConnectionQuotas connectionQuotas = server.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    @Test
    public void testIpQuotaConfigChange() {
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
        InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), ipOverrideProps);
        ConnectionQuotas connectionQuotas = ((KafkaServer)this.servers().head()).socketServer().connectionQuotas();
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10), connectionQuotas);
        DynamicConfigChangeTest.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        Properties emptyProps = new Properties();
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), connectionQuotas);
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @Test
    public void testConfigChangeOnNonExistingTopicWithAdminClient() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{op}))).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testProcessNotification() {
        new Properties().put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), 900000L, Time.SYSTEM);
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap.elem).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, this.parse(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (Long)((Log)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (Long)((Log)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (Integer)((Log)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, Log log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (Integer)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").toString()).append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").toString()).append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota, ConnectionQuotas connectionQuotas$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas$1, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }
}

