/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.api.ProducerRequest;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.DefaultPartitioner;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Resource;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.StringEncoder;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.IntEncoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$$anonfun$getMessages$1$;
import kafka.utils.TestUtils$$anonfun$verifyTopicDeletion$5$;
import kafka.utils.TestUtils$$anonfun$verifyTopicDeletion$6$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Try;
import scala.util.Try$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public String tempTopic() {
        return new StringBuilder().append((Object)"testTopic").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0)new Serializable(parentDir){
            public static final long serialVersionUID = 0L;
            private final File parentDir$1;

            public final File apply() {
                return new File(this.parentDir$1, new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.random().nextInt(1000000))).toString());
            }
            {
                this.parentDir$1 = parentDir$1;
            }
        }).take(attempts).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.mkdir();
            }
        }).getOrElse((Function0)new Serializable(attempts){
            public static final long serialVersionUID = 0L;
            private final int attempts$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory after ", " attempts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.attempts$1)})));
            }
            {
                this.attempts$1 = attempts$1;
            }
        });
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return new RandomAccessFile(this.tempFile(), "rw").getChannel();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time, KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Broker createBroker(int id, String host, int port, SecurityProtocol securityProtocol) {
        return new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    public SecurityProtocol createBroker$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1)new Serializable(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo){
            public static final long serialVersionUID = 0L;
            private final String zkConnect$1;
            private final boolean enableControlledShutdown$1;
            private final boolean enableDeleteTopic$1;
            private final Option interBrokerSecurityProtocol$1;
            private final Option trustStoreFile$1;
            private final Option saslProperties$1;
            private final boolean enablePlaintext$1;
            private final boolean enableSsl$1;
            private final boolean enableSaslPlaintext$1;
            private final boolean enableSaslSsl$1;
            private final Map rackInfo$1;

            public final Properties apply(int node) {
                int x$29 = node;
                String x$30 = this.zkConnect$1;
                boolean x$31 = this.enableControlledShutdown$1;
                boolean x$32 = this.enableDeleteTopic$1;
                int x$33 = TestUtils$.MODULE$.RandomPort();
                Option x$34 = this.interBrokerSecurityProtocol$1;
                Option x$35 = this.trustStoreFile$1;
                Option x$36 = this.saslProperties$1;
                boolean x$37 = this.enablePlaintext$1;
                boolean x$38 = this.enableSsl$1;
                boolean x$39 = this.enableSaslPlaintext$1;
                boolean x$40 = this.enableSaslSsl$1;
                Option x$41 = this.rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
                int x$42 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                int x$43 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                int x$44 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                return TestUtils$.MODULE$.createBrokerConfig(x$29, x$30, x$31, x$32, x$33, (Option<SecurityProtocol>)x$34, (Option<File>)x$35, (Option<Properties>)x$36, x$37, x$39, x$42, x$38, x$43, x$40, x$44, (Option<String>)x$41);
            }
            {
                this.zkConnect$1 = zkConnect$1;
                this.enableControlledShutdown$1 = enableControlledShutdown$1;
                this.enableDeleteTopic$1 = enableDeleteTopic$1;
                this.interBrokerSecurityProtocol$1 = interBrokerSecurityProtocol$1;
                this.trustStoreFile$1 = trustStoreFile$1;
                this.saslProperties$1 = saslProperties$1;
                this.enablePlaintext$1 = enablePlaintext$1;
                this.enableSsl$1 = enableSsl$1;
                this.enableSaslPlaintext$1 = enableSaslPlaintext$1;
                this.enableSaslSsl$1 = enableSaslSsl$1;
                this.rackInfo$1 = rackInfo$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            public final SecurityProtocol protocol$1;

            public final String apply(KafkaServer s) {
                EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getBrokerListStrFromServers.1 $outer;

                    public final boolean apply(EndPoint x$2) {
                        SecurityProtocol securityProtocol = x$2.securityProtocol();
                        SecurityProtocol securityProtocol2 = this.$outer.protocol$1;
                        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getBrokerListStrFromServers.1 $outer;

                    public final Nothing$ apply() {
                        return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with security protocol ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.protocol$1})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(TestUtils$.MODULE$.boundPort(s, this.protocol$1)));
            }
            {
                this.protocol$1 = protocol$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((TraversableOnce)servers.map((Function1)new Serializable(listenerName){
            public static final long serialVersionUID = 0L;
            public final ListenerName listenerName$1;

            public final String apply(KafkaServer s) {
                EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bootstrapServers.1 $outer;

                    public final boolean apply(EndPoint x$3) {
                        ListenerName listenerName = x$3.listenerName();
                        ListenerName listenerName2 = this.$outer.listenerName$1;
                        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bootstrapServers.1 $outer;

                    public final Nothing$ apply() {
                        return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName$1.value()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(this.listenerName$1)));
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void shutdownServers(Seq<KafkaServer> servers) {
        ((ParIterableLike)servers.par()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer s) {
                s.shutdown();
                CoreUtils$.MODULE$.delete(s.config().logDirs());
            }
        });
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack) {
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = enablePlaintext || this.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object2 = enableSsl || this.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object3 = enableSaslPlaintext || this.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslSsl || this.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SecurityProtocol, Object> x0$2) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol.name, BoxesRunTime.boxToInteger((int)port)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object5 = nodeId >= 0 ? props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        props.put(KafkaConfig$.MODULE$.LogDirProp(), this.tempDir().getAbsolutePath());
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        Object object6 = props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp()) ? BoxedUnit.UNIT : props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5");
        Object object7 = props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp()) ? BoxedUnit.UNIT : props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        rack.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$5) {
                return this.props$1.put(KafkaConfig$.MODULE$.RackProp(), x$5);
            }
            {
                this.props$1 = props$1;
            }
        });
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$3) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.usesSslTransportLayer(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(Mode.SERVER, false, trustStoreFile, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"server", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nodeId)}))));
        }
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$4) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.usesSaslAuthentication(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            props.putAll((java.util.Map<?, ?>)JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(SecurityProtocol protocol) {
                return this.props$1.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name);
            }
            {
                this.props$1 = props$1;
            }
        });
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return false;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return false;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(ZkUtils zkUtils, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminUtils$.MODULE$.createTopic(zkUtils, topic, numPartitions, replicationFactor, topicConfig, AdminUtils$.MODULE$.createTopic$default$6());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(zkUtils, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;
            private final String topic$2;
            private final Seq servers$3;

            public final Tuple2<Object, Object> apply(int i) {
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$3, this.topic$2, i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils$3, this.topic$2, i, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
            }
            {
                this.zkUtils$3 = zkUtils$3;
                this.topic$2 = topic$2;
                this.servers$3 = servers$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, partitionReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1)new Serializable(zkUtils, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;
            private final String topic$1;
            private final Seq servers$2;

            public final Tuple2<Object, Object> apply(int x0$5) {
                int n = x0$5;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$2, this.topic$1, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils$2, this.topic$1, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
                return tuple2;
            }
            {
                this.zkUtils$2 = zkUtils$2;
                this.topic$1 = topic$1;
                this.servers$2 = servers$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(ZkUtils zkUtils, Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkUtils, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public Properties createConsumerProperties(String zkConnect, String groupId, String consumerId, long consumerTimeout) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zkConnect);
        props.put("group.id", groupId);
        props.put("consumer.id", consumerId);
        props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)consumerTimeout)).toString());
        props.put("zookeeper.session.timeout.ms", "6000");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        props.put("rebalance.max.retries", "4");
        props.put("auto.offset.reset", "smallest");
        props.put("num.consumer.fetchers", "2");
        return props;
    }

    public long createConsumerProperties$default$4() {
        return -1L;
    }

    public Nothing$ fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}))), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(byte[] value) {
                return new SimpleRecord(value);
            }
        }, Seq$.MODULE$.canBuildFrom())), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7());
    }

    public MemoryRecords records(Iterable<SimpleRecord> records2, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence);
        records2.foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)new Serializable(b1, b2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer b1$1;
            private final ByteBuffer b2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)new StringBuilder().append((Object)"byte ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" byte not equal.").toString(), (long)this.b1$1.get(this.b1$1.position() + i), (long)this.b2$1.get(this.b1$1.position() + i));
            }
            {
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
            }
        });
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        int length = 0;
        while (expected.hasNext() && actual.hasNext()) {
            ++length;
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        if (expected.hasNext()) {
            int length1 = length;
            while (expected.hasNext()) {
                expected.next();
                ++length1;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- first has more: ").append((Object)BoxesRunTime.boxToInteger((int)length1)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
        if (actual.hasNext()) {
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- second has more: ").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1)new Serializable(buffer, builder){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final StringBuilder builder$2;

            public final StringBuilder apply(int i) {
                return this.builder$2.append(String.format("%x", this.buffer$1.get(this.buffer$1.position() + i)));
            }
            {
                this.buffer$1 = buffer$1;
                this.builder$2 = builder$2;
            }
        });
        return builder.toString();
    }

    public <K, V> Producer<K, V> createProducer(String brokerList, String encoder, String keyEncoder, String partitioner, Properties producerProps) {
        Properties props = this.getProducerConfig(brokerList);
        if (producerProps != null) {
            props.putAll((java.util.Map<?, ?>)producerProps);
        }
        props.put("serializer.class", encoder);
        props.put("key.serializer.class", keyEncoder);
        props.put("partitioner.class", partitioner);
        return new Producer(new ProducerConfig(props));
    }

    public <K, V> String createProducer$default$2() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$3() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$4() {
        return DefaultPartitioner.class.getName();
    }

    public <K, V> Properties createProducer$default$5() {
        return null;
    }

    private Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            props.putAll((java.util.Map<?, ?>)this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            props.putAll((java.util.Map<?, ?>)JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createNewProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, long lingerMs, long requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer, Option<Properties> props) {
        Properties producerProps = (Properties)props.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply() {
                return new Properties();
            }
        });
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)requestTimeoutMs)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"linger.ms"), (Object)((Object)BoxesRunTime.boxToLong((long)lingerMs)).toString())}));
        defaultProps.foreach((Function1)new Serializable(producerProps){
            public static final long serialVersionUID = 0L;
            private final Properties producerProps$1;

            public final Object apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = this.producerProps$1.containsKey(key) ? BoxedUnit.UNIT : this.producerProps$1.put(key, value);
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producerProps$1 = producerProps$1;
            }
        });
        if (!producerProps.containsKey("security.protocol")) {
            producerProps.putAll((java.util.Map<?, ?>)this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createNewProducer$default$2() {
        return -1;
    }

    public <K, V> long createNewProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createNewProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createNewProducer$default$5() {
        return 0;
    }

    public <K, V> long createNewProducer$default$6() {
        return 0L;
    }

    public <K, V> long createNewProducer$default$7() {
        return 10240L;
    }

    public <K, V> SecurityProtocol createNewProducer$default$8() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createNewProducer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createNewProducer$default$10() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createNewProducer$default$11() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createNewProducer$default$12() {
        return new ByteArraySerializer();
    }

    public <K, V> Option<Properties> createNewProducer$default$13() {
        return None$.MODULE$;
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", saslProperties);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", saslProperties);
    }

    public KafkaConsumer<byte[], byte[]> createNewConsumer(String brokerList, String groupId, String autoOffsetReset, long partitionFetchSize, String partitionAssignmentStrategy, int sessionTimeout, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Option<Properties> props) {
        Properties consumerProps = (Properties)props.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply() {
                return new Properties();
            }
        });
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToLong((long)partitionFetchSize)).toString());
        Map defaultProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retry.backoff.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reconnect.backoff.ms"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), (Object)"org.apache.kafka.common.serialization.ByteArrayDeserializer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition.assignment.strategy"), (Object)partitionAssignmentStrategy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"session.timeout.ms"), (Object)((Object)BoxesRunTime.boxToInteger((int)sessionTimeout)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId)}));
        defaultProps.foreach((Function1)new Serializable(consumerProps){
            public static final long serialVersionUID = 0L;
            private final Properties consumerProps$1;

            public final Object apply(Tuple2<String, String> x0$7) {
                Tuple2<String, String> tuple2 = x0$7;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = this.consumerProps$1.containsKey(key) ? BoxedUnit.UNIT : this.consumerProps$1.put(key, value);
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.consumerProps$1 = consumerProps$1;
            }
        });
        if (!consumerProps.containsKey("security.protocol")) {
            consumerProps.putAll((java.util.Map<?, ?>)this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        }
        return new KafkaConsumer(consumerProps);
    }

    public String createNewConsumer$default$2() {
        return "group";
    }

    public String createNewConsumer$default$3() {
        return "earliest";
    }

    public long createNewConsumer$default$4() {
        return 4096L;
    }

    public String createNewConsumer$default$5() {
        return RangeAssignor.class.getName();
    }

    public int createNewConsumer$default$6() {
        return 30000;
    }

    public Option<File> createNewConsumer$default$8() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$9() {
        return None$.MODULE$;
    }

    public Option<Properties> createNewConsumer$default$10() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProducerConfig(String brokerList) {
        void var2_2;
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        props.put("message.send.max.retries", "5");
        props.put("retry.backoff.ms", "1000");
        props.put("request.timeout.ms", "2000");
        props.put("request.required.acks", "-1");
        props.put("send.buffer.bytes", "65536");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSyncProducerConfig(int port) {
        void var2_2;
        Properties props = new Properties();
        props.put("host", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("request.timeout.ms", "10000");
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName());
        return var2_2;
    }

    public void updateConsumerOffset(ConsumerConfig config, String path, long offset) {
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), false);
        zkUtils.updatePersistentPath(path, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), zkUtils.updatePersistentPath$default$3());
        zkUtils.close();
    }

    public Iterator<Message> getMessageIterator(Iterator<MessageAndOffset> iter) {
        return new IteratorTemplate<Message>(iter){
            private final Iterator iter$1;

            public Message makeNext() {
                return this.iter$1.hasNext() ? ((MessageAndOffset)this.iter$1.next()).message() : (Message)this.allDone();
            }
            {
                this.iter$1 = iter$1;
            }
        };
    }

    public Seq<Broker> createBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$6) {
                return new BrokerMetadata(x$6, (Option)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom())), zkUtils);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, ZkUtils zkUtils) {
        void var3_3;
        Seq brokers = (Seq)brokerMetadatas.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(BrokerMetadata b) {
                SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
                return new Broker(b.id(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 6667, listenerName, protocol)})), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final void apply(Broker b) {
                this.zkUtils$1.registerBrokerInZk(b.id(), "localhost", 6667, b.endPoints(), -1, b.rack(), ApiVersion$.MODULE$.latestVersion());
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(ZkUtils zkUtils, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int x$7) {
                return TestUtils$.MODULE$.createBroker(x$7, "localhost", 6667, SecurityProtocol.PLAINTEXT);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$9;

            public final boolean apply(Broker b) {
                return this.zkUtils$9.deletePath(new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)b).toString());
            }
            {
                this.zkUtils$9 = zkUtils$9;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$2;

            public final ListBuffer<String> apply(int i) {
                return this.buffer$2.$plus$eq((Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return this.produceRequestWithAcks((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition}))), message, acks, timeout, correlationId, clientId);
    }

    public int produceRequest$default$6() {
        return 0;
    }

    public ProducerRequest produceRequestWithAcks(Seq<String> topics, Seq<Object> partitions, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        Seq data = (Seq)topics.flatMap((Function1)new Serializable(partitions, message){
            public static final long serialVersionUID = 0L;
            private final Seq partitions$1;
            public final ByteBufferMessageSet message$1;

            public final Seq<Tuple2<TopicAndPartition, ByteBufferMessageSet>> apply(String topic) {
                return (Seq)this.partitions$1.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.13 $outer;
                    private final String topic$10;

                    public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(int partition) {
                        return new Tuple2((Object)new TopicAndPartition(this.topic$10, partition), (Object)this.$outer.message$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$10 = topic$10;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.partitions$1 = partitions$1;
                this.message$1 = message$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new ProducerRequest(correlationId, clientId, (short)acks, timeout, (scala.collection.mutable.Map)Map$.MODULE$.apply(data));
    }

    public int produceRequestWithAcks$default$6() {
        return 0;
    }

    public void makeLeaderForPartition(ZkUtils zkUtils, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        leaderPerPartitionMap.foreach((Function1)new Serializable(zkUtils, topic, controllerEpoch){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$7;
            public final String topic$6;
            private final int controllerEpoch$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<Object, Object> x0$8) {
                BoxedUnit boxedUnit;
                Tuple2<Object, Object> tuple2 = x0$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                int partition = tuple2._1$mcI$sp();
                int leader2 = tuple2._2$mcI$sp();
                try {
                    LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)this.zkUtils$7.getLeaderAndIsrForPartition(this.topic$6, partition).map((Function1)new Serializable(this, leader2){
                        public static final long serialVersionUID = 0L;
                        private final int leader$1;

                        public final LeaderAndIsr apply(LeaderAndIsr x$8) {
                            return x$8.newLeader(this.leader$1);
                        }
                        {
                            this.leader$1 = leader$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, leader2){
                        public static final long serialVersionUID = 0L;
                        private final int leader$1;

                        public final LeaderAndIsr apply() {
                            return LeaderAndIsr$.MODULE$.apply(this.leader$1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leader$1})));
                        }
                        {
                            this.leader$1 = leader$1;
                        }
                    });
                    this.zkUtils$7.updatePersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic$6, partition), this.zkUtils$7.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch$1), this.zkUtils$7.updatePersistentPath$default$3());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    TestUtils$.MODULE$.error((Function0<String>)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeLeaderForPartition.1 $outer;
                        private final int partition$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while electing leader for partition [", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$6, BoxesRunTime.boxToInteger((int)this.partition$3)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$3 = partition$3;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable oe$1;

                        public final Throwable apply() {
                            return this.oe$1;
                        }
                        {
                            this.oe$1 = oe$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.zkUtils$7 = zkUtils$7;
                this.topic$6 = topic$6;
                this.controllerEpoch$1 = controllerEpoch$1;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public int waitUntilLeaderIsElectedOrChanged(ZkUtils zkUtils, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(oldLeaderOpt.isDefined() == false || newLeaderOpt.isDefined() == false, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't define both the old and the new leader";
            }
        });
        startTime = System.currentTimeMillis();
        topicPartition = new TopicPartition(topic, partition);
        this.trace((Function0<String>)new Serializable(oldLeaderOpt, newLeaderOpt, topicPartition){
            public static final long serialVersionUID = 0L;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for leader to be elected or changed for partition ", ", old leader is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, this.oldLeaderOpt$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newLeaderOpt$1}))).toString();
            }
            {
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        leader = ObjectRef.create((Object)None$.MODULE$);
        electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            block11: {
                block10: {
                    block6: {
                        block8: {
                            block9: {
                                block7: {
                                    leader.elem = zkUtils.getLeaderForPartition(topic, partition);
                                    var13_11 = (Option)leader.elem;
                                    if (!(var13_11 instanceof Some)) break block6;
                                    var14_12 = (Some)var13_11;
                                    l = BoxesRunTime.unboxToInt((Object)var14_12.x());
                                    var17_15 = new Tuple2(newLeaderOpt, oldLeaderOpt);
                                    if (var17_15 == null || !((var18_16 = (Option)var17_15._1()) instanceof Some) || (newLeader = BoxesRunTime.unboxToInt((Object)(var19_17 = (Some)var18_16).x())) != l) break block7;
                                    this.trace((Function0<String>)new Serializable(topicPartition, l){
                                        public static final long serialVersionUID = 0L;
                                        private final TopicPartition topicPartition$1;
                                        private final int l$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected new leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topicPartition$1}));
                                        }
                                        {
                                            this.topicPartition$1 = topicPartition$1;
                                            this.l$1 = l$1;
                                        }
                                    });
                                    electedOrChangedLeader = (Option)leader.elem;
                                    var21_19 = BoxedUnit.UNIT;
                                    break block8;
                                }
                                if (var17_15 == null || !((var22_20 = (Option)var17_15._2()) instanceof Some) || (oldLeader = BoxesRunTime.unboxToInt((Object)(var23_21 = (Some)var22_20).x())) == l) break block9;
                                this.trace((Function0<String>)new Serializable(topicPartition, l, oldLeader){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$1;
                                    private final int l$1;
                                    private final int oldLeader$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.oldLeader$1), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                    }
                                    {
                                        this.topicPartition$1 = topicPartition$1;
                                        this.l$1 = l$1;
                                        this.oldLeader$1 = oldLeader$1;
                                    }
                                });
                                electedOrChangedLeader = (Option)leader.elem;
                                var21_19 = BoxedUnit.UNIT;
                                break block8;
                            }
                            if (var17_15 == null) ** GOTO lbl-1000
                            var25_23 = (Option)var17_15._1();
                            var26_24 = (Option)var17_15._2();
                            if (None$.MODULE$.equals(var25_23) && None$.MODULE$.equals(var26_24)) {
                                this.trace((Function0<String>)new Serializable(topicPartition, l){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$1;
                                    private final int l$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topicPartition$1}));
                                    }
                                    {
                                        this.topicPartition$1 = topicPartition$1;
                                        this.l$1 = l$1;
                                    }
                                });
                                electedOrChangedLeader = (Option)leader.elem;
                                var21_19 = BoxedUnit.UNIT;
                            } else lbl-1000:
                            // 2 sources

                            {
                                this.trace((Function0<String>)new Serializable(topicPartition, l){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$1;
                                    private final int l$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current leader for partition ", " is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.l$1)}));
                                    }
                                    {
                                        this.topicPartition$1 = topicPartition$1;
                                        this.l$1 = l$1;
                                    }
                                });
                                var21_19 = BoxedUnit.UNIT;
                            }
                        }
                        var16_14 = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!None$.MODULE$.equals(var13_11)) break block11;
                    this.trace((Function0<String>)new Serializable(topicPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is not elected yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
                        }
                        {
                            this.topicPartition$1 = topicPartition$1;
                        }
                    });
                    var16_14 = BoxedUnit.UNIT;
                }
                Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
                continue;
            }
            throw new MatchError((Object)var13_11);
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0)new Serializable(timeoutMs, oldLeaderOpt, newLeaderOpt, topicPartition, leader){
            public static final long serialVersionUID = 0L;
            private final long timeoutMs$1;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;
            private final TopicPartition topicPartition$1;
            private final ObjectRef leader$2;

            public final Nothing$ apply() {
                Option option;
                String string;
                Option option2;
                Tuple2 tuple2 = new Tuple2((Object)this.newLeaderOpt$1, (Object)this.oldLeaderOpt$1);
                if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
                    Some some = (Some)option2;
                    int newLeader = BoxesRunTime.unboxToInt((Object)some.x());
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since expected new leader ", " was not elected for partition ", ", leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), BoxesRunTime.boxToInteger((int)newLeader), this.topicPartition$1, (Option)this.leader$2.elem}));
                } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
                    Some some = (Some)option;
                    int oldLeader = BoxesRunTime.unboxToInt((Object)some.x());
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a new leader that is different from ", " was not elected for partition ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), BoxesRunTime.boxToInteger((int)oldLeader), this.topicPartition$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Option)this.leader$2.elem}))).toString();
                } else {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a leader was not elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), this.topicPartition$1}));
                }
                String errorMessage = string;
                return TestUtils$.MODULE$.fail(errorMessage);
            }
            {
                this.timeoutMs$1 = timeoutMs$1;
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
                this.topicPartition$1 = topicPartition$1;
                this.leader$2 = leader$2;
            }
        }));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        {
            block.apply$mcV$sp();
            return;
        }
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTime, long pause) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                throw this.fail((String)msg.apply());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return;
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().getPartition(new TopicPartition(topic, partitionId)).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Partition x$9) {
                return x$9.leaderReplicaIfLocal().isDefined();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer createRequestByteBuffer(RequestOrResponse request) {
        void var2_2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.sizeInBytes() + 2);
        byteBuffer.putShort(BoxesRunTime.unboxToShort((Object)request.requestId().get()));
        request.writeTo(byteBuffer);
        byteBuffer.rewind();
        return var2_2;
    }

    public void waitUntilBrokerMetadataIsPropagated(Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((TraversableOnce)servers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$10) {
                return x$10.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, expectedBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Seq servers$1;
            public final Set expectedBrokerIds$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilBrokerMetadataIsPropagated.1 $outer;

                    public final boolean apply(KafkaServer server) {
                        Set set = this.$outer.expectedBrokerIds$1;
                        Set set2 = ((TraversableOnce)server.apis().metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Broker x$11) {
                                return x$11.id();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toSet();
                        return !(set != null ? !set.equals(set2) : set2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$1 = servers$1;
                this.expectedBrokerIds$1 = expectedBrokerIds$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for broker metadata to propagate to all servers";
            }
        }, timeout, this.waitUntilTrue$default$4());
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader2 = IntRef.create((int)-1);
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition, leader2){
            public static final long serialVersionUID = 0L;
            private final Seq servers$5;
            public final String topic$4;
            public final int partition$1;
            public final IntRef leader$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$5.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilMetadataIsPropagated.1 $outer;

                    public final boolean apply(boolean result, KafkaServer server) {
                        Option option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    Option partitionStateOpt = server.apis().metadataCache().getPartitionInfo(this.$outer.topic$4, this.$outer.partition$1);
                                    option = partitionStateOpt;
                                    if (!None$.MODULE$.equals(option)) break block2;
                                    bl = false;
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
                                this.$outer.leader$3.elem = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
                                bl = result && Request$.MODULE$.isValidBrokerId(this.$outer.leader$3.elem);
                            }
                            return bl;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$5 = servers$5;
                this.topic$4 = topic$4;
                this.partition$1 = partition$1;
                this.leader$3 = leader$3;
            }
        }, (Function0<String>)new Serializable(topic, partition, timeout){
            public static final long serialVersionUID = 0L;
            private final String topic$4;
            private final int partition$1;
            private final long timeout$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToLong((long)this.timeout$1)}));
            }
            {
                this.topic$4 = topic$4;
                this.partition$1 = partition$1;
                this.timeout$1 = timeout$1;
            }
        }, timeout, this.waitUntilTrue$default$4());
        return leader2.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 15000L;
    }

    public int waitUntilControllerElected(ZkUtils zkUtils, long timeout) {
        ObjectRef controllerIdTry = ObjectRef.create(null);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, controllerIdTry){
            public static final long serialVersionUID = 0L;
            public final ZkUtils zkUtils$10;
            private final ObjectRef controllerIdTry$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.controllerIdTry$1.elem = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilControllerElected.1 $outer;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.zkUtils$10.getController();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return ((Try)this.controllerIdTry$1.elem).isSuccess();
            }
            {
                this.zkUtils$10 = zkUtils$10;
                this.controllerIdTry$1 = controllerIdTry$1;
            }
        }, (Function0<String>)new Serializable(timeout){
            public static final long serialVersionUID = 0L;
            private final long timeout$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller not elected after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeout$3)}));
            }
            {
                this.timeout$3 = timeout$3;
            }
        }, timeout, this.waitUntilTrue$default$4());
        return BoxesRunTime.unboxToInt((Object)((Try)controllerIdTry.elem).get());
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public void waitUntilLeaderIsKnown(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        TopicPartition tp = new TopicPartition(topic, partition);
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, tp){
            public static final long serialVersionUID = 0L;
            private final Seq servers$7;
            public final TopicPartition tp$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$7.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilLeaderIsKnown.1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.replicaManager().getPartition(this.$outer.tp$1).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Partition x$12) {
                                return x$12.leaderReplicaIfLocal().isDefined();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$7 = servers$7;
                this.tp$1 = tp$1;
            }
        }, (Function0<String>)new Serializable(timeout, tp){
            public static final long serialVersionUID = 0L;
            private final long timeout$4;
            private final TopicPartition tp$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " leaders not made yet after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.timeout$4)}));
            }
            {
                this.timeout$4 = timeout$4;
                this.tp$1 = tp$1;
            }
        }, timeout, this.waitUntilTrue$default$4());
    }

    public long waitUntilLeaderIsKnown$default$4() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size2) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile file$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.file$1.writeByte(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$1 = file$1;
            }
        });
        file.close();
    }

    public void appendNonsenseToFile(File fileName, int size2) {
        FileOutputStream file = new FileOutputStream(fileName, true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream file$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.file$2.write(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$2 = file$2;
            }
        });
        file.close();
    }

    public void checkForPhantomInSyncReplicas(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Seq inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partitionToBeReassigned);
        Set phantomInSyncReplicas = (Set)inSyncReplicas.toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (boolean)phantomInSyncReplicas.isEmpty());
    }

    public void ensureNoUnderReplicatedPartitions(ZkUtils zkUtils, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic, partitionToBeReassigned, assignedReplicas){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$8;
            private final String topic$7;
            private final int partitionToBeReassigned$1;
            private final Seq assignedReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Seq inSyncReplicas = this.zkUtils$8.getInSyncReplicasForPartition(this.topic$7, this.partitionToBeReassigned$1);
                return inSyncReplicas.size() == this.assignedReplicas$1.size();
            }
            {
                this.zkUtils$8 = zkUtils$8;
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.assignedReplicas$1 = assignedReplicas$1;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1)}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        ObjectRef leader2 = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic, partitionToBeReassigned, leader2){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$8;
            private final String topic$7;
            private final int partitionToBeReassigned$1;
            private final ObjectRef leader$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.leader$4.elem = this.zkUtils$8.getLeaderForPartition(this.topic$7, this.partitionToBeReassigned$1);
                return ((Option)this.leader$4.elem).isDefined();
            }
            {
                this.zkUtils$8 = zkUtils$8;
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.leader$4 = leader$4;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1)}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, leader2){
            public static final long serialVersionUID = 0L;
            private final Seq servers$6;
            public final ObjectRef leader$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                KafkaServer leaderBroker = (KafkaServer)((IterableLike)this.servers$6.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ensureNoUnderReplicatedPartitions.3 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)this.$outer.leader$4.elem).get());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).head();
                return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
            }
            {
                this.servers$6 = servers$6;
                this.leader$4 = leader$4;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned, leader2){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;
            private final ObjectRef leader$4;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1), ((Option)this.leader$4.elem).get()}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.leader$4 = leader$4;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public boolean checkIfReassignPartitionPathExists(ZkUtils zkUtils) {
        return zkUtils.pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
    }

    public void verifyNonDaemonThreadsStatus(String threadNamePrefix) {
        int threadCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).count((Function1)new Serializable(threadNamePrefix){
            public static final long serialVersionUID = 0L;
            private final String threadNamePrefix$1;

            public final boolean apply(Thread t) {
                return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.threadNamePrefix$1);
            }
            {
                this.threadNamePrefix$1 = threadNamePrefix$1;
            }
        });
        Assert.assertEquals((long)0L, (long)threadCount);
    }

    public LogManager createLogManager(File[] logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        File[] x$54 = logDirs;
        Map x$55 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$56 = defaultConfig;
        CleanerConfig x$57 = cleanerConfig;
        int x$58 = 4;
        long x$59 = 1000L;
        long x$60 = 10000L;
        long x$61 = 10000L;
        long x$62 = 1000L;
        int x$63 = 3600000;
        MockScheduler x$64 = time.scheduler();
        MockTime x$65 = time;
        BrokerState x$66 = new BrokerState();
        BrokerTopicStats x$67 = new BrokerTopicStats();
        return new LogManager(x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, (Scheduler)x$64, x$66, x$67, (Time)x$65);
    }

    public File[] createLogManager$default$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$117 = false;
        int x$118 = CleanerConfig$.MODULE$.apply$default$1();
        long x$119 = CleanerConfig$.MODULE$.apply$default$2();
        double x$120 = CleanerConfig$.MODULE$.apply$default$3();
        int x$121 = CleanerConfig$.MODULE$.apply$default$4();
        int x$122 = CleanerConfig$.MODULE$.apply$default$5();
        double x$123 = CleanerConfig$.MODULE$.apply$default$6();
        long x$124 = CleanerConfig$.MODULE$.apply$default$7();
        String x$125 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$117, x$125);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public List<String> sendMessages(Seq<KafkaServer> servers, String topic, int numMessages, int partition, CompressionCodec compression) {
        List list;
        String header = new StringOps(Predef$.MODULE$.augmentString("test-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)}));
        Properties props = new Properties();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)compression.codec())).toString());
        IndexedSeq ms = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(header){
            public static final long serialVersionUID = 0L;
            private final String header$1;

            public final String apply(int x) {
                return new StringBuilder().append((Object)this.header$1).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)x)).toString();
            }
            {
                this.header$1 = header$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        if (partition >= 0) {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), IntEncoder.class.getName(), FixedValuePartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1)new Serializable(topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$9;
                private final int partition$2;

                public final KeyedMessage<Object, String> apply(String m) {
                    return new KeyedMessage(this.topic$9, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)m);
                }
                {
                    this.topic$9 = topic$9;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom()));
            this.debug((Function0<String>)new Serializable(topic, partition, ms){
                public static final long serialVersionUID = 0L;
                private final String topic$9;
                private final int partition$2;
                private final IndexedSeq ms$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$1.size()), this.topic$9, BoxesRunTime.boxToInteger((int)this.partition$2)}));
                }
                {
                    this.topic$9 = topic$9;
                    this.partition$2 = partition$2;
                    this.ms$1 = ms$1;
                }
            });
            producer.close();
            list = ms.toList();
        } else {
            Producer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), DefaultPartitioner.class.getName(), props);
            producer.send((Seq)ms.map((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$9;

                public final KeyedMessage<String, String> apply(String m) {
                    return new KeyedMessage(this.topic$9, (Object)this.topic$9, (Object)m);
                }
                {
                    this.topic$9 = topic$9;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom()));
            producer.close();
            this.debug((Function0<String>)new Serializable(topic, ms){
                public static final long serialVersionUID = 0L;
                private final String topic$9;
                private final IndexedSeq ms$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for topic [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$1.size()), this.topic$9}));
                }
                {
                    this.topic$9 = topic$9;
                    this.ms$1 = ms$1;
                }
            });
            list = ms.toList();
        }
        return list;
    }

    public int sendMessages$default$4() {
        return -1;
    }

    public CompressionCodec sendMessages$default$5() {
        return NoCompressionCodec$.MODULE$;
    }

    public Seq<byte[]> produceMessages(Seq<KafkaServer> servers, String topic, int numMessages, int acks, int valueBytes) {
        String x$68 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$69 = 5;
        long x$70 = 2000L;
        int x$71 = acks;
        long x$72 = this.createNewProducer$default$3();
        long x$73 = this.createNewProducer$default$4();
        long x$74 = this.createNewProducer$default$6();
        SecurityProtocol x$75 = this.createNewProducer$default$8();
        Option<File> x$76 = this.createNewProducer$default$9();
        Option<Properties> x$77 = this.createNewProducer$default$10();
        ByteArraySerializer x$78 = this.createNewProducer$default$11();
        ByteArraySerializer x$79 = this.createNewProducer$default$12();
        Option<Properties> x$80 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$68, x$71, x$72, x$73, x$69, x$74, x$70, x$75, x$76, x$77, (Serializer)x$78, (Serializer)x$79, x$80);
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(valueBytes){
            public static final long serialVersionUID = 0L;
            private final int valueBytes$1;

            public final byte[] apply(int x) {
                byte[] byArray;
                int n = this.valueBytes$1;
                switch (n) {
                    default: {
                        byArray = new byte[this.valueBytes$1];
                        break;
                    }
                    case -1: {
                        byArray = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})).getBytes();
                    }
                }
                return byArray;
            }
            {
                this.valueBytes$1 = valueBytes$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq futures = (IndexedSeq)values.map((Function1)new Serializable(topic, producer){
            public static final long serialVersionUID = 0L;
            private final String topic$8;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(byte[] value) {
                return this.producer$1.send(new ProducerRecord(this.topic$8, (Object)value));
            }
            {
                this.topic$8 = topic$8;
                this.producer$1 = producer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$13) {
                return x$13.get();
            }
        });
        producer.close();
        this.debug((Function0<String>)new Serializable(topic, values){
            public static final long serialVersionUID = 0L;
            private final String topic$8;
            private final IndexedSeq values$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages for topic [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.values$1.size()), this.topic$8}));
            }
            {
                this.topic$8 = topic$8;
                this.values$1 = values$1;
            }
        });
        return values;
    }

    public void produceMessage(Seq<KafkaServer> servers, String topic, String message) {
        String x$81 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$82 = 5;
        long x$83 = 2000L;
        int x$84 = this.createNewProducer$default$2();
        long x$85 = this.createNewProducer$default$3();
        long x$86 = this.createNewProducer$default$4();
        long x$87 = this.createNewProducer$default$6();
        SecurityProtocol x$88 = this.createNewProducer$default$8();
        Option<File> x$89 = this.createNewProducer$default$9();
        Option<Properties> x$90 = this.createNewProducer$default$10();
        ByteArraySerializer x$91 = this.createNewProducer$default$11();
        ByteArraySerializer x$92 = this.createNewProducer$default$12();
        Option<Properties> x$93 = this.createNewProducer$default$13();
        KafkaProducer producer = this.createNewProducer(x$81, x$84, x$85, x$86, x$82, x$87, x$83, x$88, x$89, x$90, (Serializer)x$91, (Serializer)x$92, x$93);
        producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        producer.close();
    }

    public int produceMessages$default$4() {
        return -1;
    }

    public int produceMessages$default$5() {
        return -1;
    }

    public List<String> getMessages(Map<String, List<KafkaStream<String, String>>> topicMessageStreams, int nMessagesPerThread) {
        ObjectRef messages = ObjectRef.create((Object)Nil$.MODULE$);
        boolean shouldGetAllMessages = nMessagesPerThread < 0;
        topicMessageStreams.values().foreach((Function1)new Serializable(nMessagesPerThread, messages, shouldGetAllMessages){
            public static final long serialVersionUID = 0L;
            public final int nMessagesPerThread$1;
            public final ObjectRef messages$1;
            public final boolean shouldGetAllMessages$1;

            public final void apply(List<KafkaStream<String, String>> messageStreams) {
                messageStreams.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getMessages.1 $outer;

                    public final void apply(KafkaStream<String, String> messageStream) {
                        ConsumerTimeoutException consumerTimeoutException2;
                        block3: {
                            ConsumerIterator iterator = messageStream.iterator();
                            try {
                                for (int i = 0; this.$outer.shouldGetAllMessages$1 && iterator.hasNext() || i < this.$outer.nMessagesPerThread$1; ++i) {
                                    Assert.assertTrue((boolean)iterator.hasNext());
                                    String message = (String)iterator.next().message();
                                    this.$outer.messages$1.elem = ((List)this.$outer.messages$1.elem).$colon$colon((Object)message);
                                    TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, message){
                                        public static final long serialVersionUID = 0L;
                                        private final String message$3;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"received message: ").append((Object)this.message$3).toString();
                                        }
                                        {
                                            this.message$3 = message$3;
                                        }
                                    });
                                }
                            }
                            catch (ConsumerTimeoutException consumerTimeoutException2) {
                                if (!this.$outer.shouldGetAllMessages$1) break block3;
                                TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$getMessages$1$$anonfun$apply$6 $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)((List)this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().messages$1.elem).length())).append((Object)" message(s).").toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            return;
                        }
                        throw consumerTimeoutException2;
                    }

                    public /* synthetic */ anonfun.getMessages.1 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.nMessagesPerThread$1 = nMessagesPerThread$1;
                this.messages$1 = messages$1;
                this.shouldGetAllMessages$1 = shouldGetAllMessages$1;
            }
        });
        return ((List)messages.elem).reverse();
    }

    public int getMessages$default$2() {
        return -1;
    }

    public void verifyTopicDeletion(ZkUtils zkUtils, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final TopicPartition apply(int x$14) {
                return new TopicPartition(this.topic$3, x$14);
            }
            {
                this.topic$3 = topic$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$4;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkUtils$4.isTopicMarkedForDeletion(this.topic$3);
            }
            {
                this.zkUtils$4 = zkUtils$4;
                this.topic$3 = topic$3;
            }
        }, (Function0<String>)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
            }
            {
                this.topic$3 = topic$3;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$4;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkUtils$4.pathExists(ZkUtils$.MODULE$.getTopicPath(this.topic$3));
            }
            {
                this.zkUtils$4 = zkUtils$4;
                this.topic$3 = topic$3;
            }
        }, (Function0<String>)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topic/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, this.topic$3}));
            }
            {
                this.topic$3 = topic$3;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.3 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$1;

                            public final boolean apply(TopicPartition tp) {
                                return this.server$1.replicaManager().getPartition(tp).isEmpty();
                            }
                            {
                                this.server$1 = server$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica manager's should have deleted all of this topic's partitions";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1)new Serializable(topicPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$2;

                    public final boolean apply(TopicPartition tp) {
                        return this.server$2.getLogManager().getLog(tp).isEmpty();
                    }
                    {
                        this.server$2 = server$2;
                    }
                });
            }
            {
                this.topicPartitions$1 = topicPartitions$1;
            }
        }));
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.4 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$3;

                            public final boolean apply(TopicPartition tp) {
                                Map[] checkpoints = (Map[])Predef$.MODULE$.refArrayOps((Object[])this.server$3.getLogManager().logDirs()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Map<TopicPartition, Object> apply(File logDir) {
                                        return new OffsetCheckpointFile(new File(logDir, "cleaner-offset-checkpoint")).read();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
                                return Predef$.MODULE$.refArrayOps((Object[])checkpoints).forall((Function1)new Serializable(this, tp){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition tp$2;

                                    public final boolean apply(Map<TopicPartition, Object> checkpointsPerLogDir) {
                                        return !checkpointsPerLogDir.contains((Object)this.tp$2);
                                    }
                                    {
                                        this.tp$2 = tp$2;
                                    }
                                });
                            }
                            {
                                this.server$3 = server$3;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cleaner offset for deleted partition should have been removed";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.5 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.config().logDirs().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$verifyTopicDeletion$5$$anonfun$apply$mcZ$sp$7 $outer;

                            public final boolean apply(String logDir) {
                                return this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().topicPartitions$1.forall((Function1)new Serializable(this, logDir){
                                    public static final long serialVersionUID = 0L;
                                    private final String logDir$1;

                                    public final boolean apply(TopicPartition tp) {
                                        return !new File(this.logDir$1, new StringBuilder().append((Object)tp.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)tp.partition())).toString()).exists();
                                    }
                                    {
                                        this.logDir$1 = logDir$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.verifyTopicDeletion.5 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to soft-delete the data to a delete directory";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.6 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.config().logDirs().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$verifyTopicDeletion$6$$anonfun$apply$mcZ$sp$8 $outer;

                            public final boolean apply(String logDir) {
                                return this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().topicPartitions$1.forall((Function1)new Serializable(this, logDir){
                                    public static final long serialVersionUID = 0L;
                                    private final String logDir$2;

                                    public final boolean apply(TopicPartition tp) {
                                        return !((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(this.logDir$2).list()})).asScala()).exists((Function1)new Serializable(this, tp){
                                            public static final long serialVersionUID = 0L;
                                            private final TopicPartition tp$3;

                                            public final boolean apply(String[] partitionDirectoryName) {
                                                return Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName).startsWith((GenSeq)Predef$.MODULE$.wrapString(new StringBuilder().append((Object)this.tp$3.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.tp$3.partition())).toString())) && Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName).endsWith((GenSeq)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
                                            }
                                            {
                                                this.tp$3 = tp$3;
                                            }
                                        });
                                    }
                                    {
                                        this.logDir$2 = logDir$2;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.verifyTopicDeletion.6 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to hard-delete the delete directory";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        copy.putAll((java.util.Map<?, ?>)props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception("SSL enabled but no trustStoreFile provided");
            }
        });
        java.util.Map sslConfigs2 = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias);
        Properties sslProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sslConfigs2).asScala()).foreach((Function1)new Serializable(sslProps){
            public static final long serialVersionUID = 0L;
            private final Properties sslProps$1;

            public final Object apply(Tuple2<String, Object> x0$9) {
                Tuple2<String, Object> tuple2 = x0$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Object object = this.sslProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sslProps$1 = sslProps$1;
            }
        });
        return sslProps;
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public void waitAndVerifyAcls(Set<Acl> expected, Authorizer authorizer, Resource resource) {
        this.waitUntilTrue((Function0<Object>)new Serializable(expected, authorizer, resource){
            public static final long serialVersionUID = 0L;
            private final Set expected$1;
            private final Authorizer authorizer$1;
            private final Resource resource$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set set = this.authorizer$1.getAcls(this.resource$1);
                Set set2 = this.expected$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                this.expected$1 = expected$1;
                this.authorizer$1 = authorizer$1;
                this.resource$1 = resource$1;
            }
        }, (Function0<String>)new Serializable(expected, authorizer, resource){
            public static final long serialVersionUID = 0L;
            private final Set expected$1;
            private final Authorizer authorizer$1;
            private final Resource resource$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected acls ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expected$1, this.authorizer$1.getAcls(this.resource$1)}));
            }
            {
                this.expected$1 = expected$1;
                this.authorizer$1 = authorizer$1;
                this.resource$1 = resource$1;
            }
        }, 15000L, this.waitUntilTrue$default$4());
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        boolean bl;
        this.debug((Function0<String>)new Serializable(acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$1}));
            }
            {
                this.acl$1 = acl$1;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "sasl";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string3 = "world";
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAclUnsecure(ACL acl) {
        boolean bl;
        this.debug((Function0<String>)new Serializable(acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$2}));
            }
            {
                this.acl$2 = acl$2;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
        }
        return bl;
    }

    private Seq<String> secureZkPaths(ZkUtils zkUtils) {
        Seq topLevelPaths = (Seq)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom());
        return (Seq)topLevelPaths.flatMap((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$11;

            public final Seq<String> apply(String path) {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$subPaths$1(path, this.zkUtils$11);
            }
            {
                this.zkUtils$11 = zkUtils$11;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void verifySecureZkAcls(ZkUtils zkUtils, int usersWithAccess) {
        this.secureZkPaths(zkUtils).foreach((Function1)new Serializable(zkUtils, usersWithAccess){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$6;
            private final int usersWithAccess$1;

            public final void apply(String path) {
                if (this.zkUtils$6.pathExists(path)) {
                    boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
                    int aclCount = sensitive ? this.usersWithAccess$1 : this.usersWithAccess$1 + 1;
                    java.util.List acls = (java.util.List)this.zkUtils$6.zkConnection().getAcl(path).getKey();
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)aclCount, (long)acls.size());
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1)new Serializable(this, sensitive){
                        public static final long serialVersionUID = 0L;
                        private final boolean sensitive$1;

                        public final boolean apply(ACL acl) {
                            return TestUtils$.MODULE$.isAclSecure(acl, this.sensitive$1);
                        }
                        {
                            this.sensitive$1 = sensitive$1;
                        }
                    });
                }
            }
            {
                this.zkUtils$6 = zkUtils$6;
                this.usersWithAccess$1 = usersWithAccess$1;
            }
        });
    }

    public void verifyUnsecureZkAcls(ZkUtils zkUtils) {
        this.secureZkPaths(zkUtils).foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;

            public final void apply(String path) {
                if (this.zkUtils$5.pathExists(path)) {
                    java.util.List acls = (java.util.List)this.zkUtils$5.zkConnection().getAcl(path).getKey();
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)1L, (long)acls.size());
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ACL acl) {
                            return TestUtils$.MODULE$.isAclUnsecure(acl);
                        }
                    });
                }
            }
            {
                this.zkUtils$5 = zkUtils$5;
            }
        });
    }

    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        int numThreads = functions.size();
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ArrayBuffer arrayBuffer;
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Function0<Object> function) {
                        return new Callable<BoxedUnit>(this, function){
                            private final Function0 function$1;

                            public void call() {
                                this.function$1.apply();
                            }
                            {
                                this.function$1 = function$1;
                            }
                        };
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1)new Serializable(message, timeoutMs, exceptions){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;
                    private final int timeoutMs$2;
                    private final ArrayBuffer exceptions$1;

                    public final Object apply(Future<BoxedUnit> future) {
                        BoxedUnit boxedUnit;
                        if (future.isCancelled()) {
                            TestUtils$.MODULE$.kafka$utils$TestUtils$$failWithTimeout$1(this.message$2, this.timeoutMs$2);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            try {
                                boxedUnit = future.get();
                            }
                            catch (Exception exception) {
                                boxedUnit = this.exceptions$1.$plus$eq((Object)exception);
                            }
                        }
                        return boxedUnit;
                    }
                    {
                        this.message$2 = message$2;
                        this.timeoutMs$2 = timeoutMs$2;
                        this.exceptions$1 = exceptions$1;
                    }
                });
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                arrayBuffer = exceptions.$plus$eq((Object)throwable);
            }
            catch (InterruptedException interruptedException) {
                this.kafka$utils$TestUtils$$failWithTimeout$1(message, timeoutMs);
                arrayBuffer = BoxedUnit.UNIT;
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with exception(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, exceptions})), (boolean)exceptions.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(Seq<KafkaServer> servers, String topic, int numMessages, long waitTime) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        String x$94 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$95 = SecurityProtocol.PLAINTEXT;
        String x$96 = this.createNewConsumer$default$2();
        String x$97 = this.createNewConsumer$default$3();
        long x$98 = this.createNewConsumer$default$4();
        String x$99 = this.createNewConsumer$default$5();
        int x$100 = this.createNewConsumer$default$6();
        Option<File> x$101 = this.createNewConsumer$default$8();
        Option<Properties> x$102 = this.createNewConsumer$default$9();
        Option<Properties> x$103 = this.createNewConsumer$default$10();
        KafkaConsumer<byte[], byte[]> consumer = this.createNewConsumer(x$94, x$96, x$97, x$98, x$99, x$100, x$95, x$101, x$102, x$103);
        try {
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        catch (Throwable throwable) {
            void var6_15;
            var6_15.close();
            throw throwable;
        }
        consumer.close();
        return seq;
    }

    public <K, V> long consumeTopicRecords$default$4() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecords(KafkaConsumer<K, V> consumer, int numMessages, long waitTime) {
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, numMessages, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;
            private final int numMessages$1;
            private final ArrayBuffer records$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer$1.poll(50L)).asScala());
                return this.records$1.size() >= this.numMessages$1;
            }
            {
                this.consumer$1 = consumer$1;
                this.numMessages$1 = numMessages$1;
                this.records$1 = records$1;
            }
        }, (Function0<String>)new Serializable(numMessages, records2){
            public static final long serialVersionUID = 0L;
            private final int numMessages$1;
            private final ArrayBuffer records$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout instead of the expected ", " records"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size()), BoxesRunTime.boxToInteger((int)this.numMessages$1)}));
            }
            {
                this.numMessages$1 = numMessages$1;
                this.records$1 = records$1;
            }
        }, waitTime, this.waitUntilTrue$default$4());
        Assert.assertEquals((String)"Consumed more records than expected", (long)numMessages, (long)records2.size());
        return records2;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRemainingRecords(KafkaConsumer<K, V> consumer, long timeout) {
        long startTime = System.currentTimeMillis();
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, timeout, startTime, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final long timeout$2;
            private final long startTime$1;
            private final ArrayBuffer records$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer$5.poll(50L)).asScala());
                return System.currentTimeMillis() - this.startTime$1 > this.timeout$2;
            }
            {
                this.consumer$5 = consumer$5;
                this.timeout$2 = timeout$2;
                this.startTime$1 = startTime$1;
                this.records$2 = records$2;
            }
        }, (Function0<String>)new Serializable(timeout){
            public static final long serialVersionUID = 0L;
            private final long timeout$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timeout ", " was greater than the maximum wait time."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeout$2)}));
            }
            {
                this.timeout$2 = timeout$2;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return records2;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, Seq<KafkaServer> servers, int batchSize, long transactionTimeoutMs) {
        Properties props = new Properties();
        props.put("transactional.id", transactionalId);
        props.put("max.in.flight.requests.per.connection", "1");
        props.put("enable.idempotence", "true");
        props.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        props.put("transaction.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)transactionTimeoutMs)).toString());
        String x$16 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$17 = Integer.MAX_VALUE;
        int x$18 = -1;
        Some x$19 = new Some((Object)props);
        long x$20 = this.createNewProducer$default$3();
        long x$21 = this.createNewProducer$default$4();
        long x$22 = this.createNewProducer$default$6();
        long x$23 = this.createNewProducer$default$7();
        SecurityProtocol x$24 = this.createNewProducer$default$8();
        Option<File> x$25 = this.createNewProducer$default$9();
        Option<Properties> x$26 = this.createNewProducer$default$10();
        ByteArraySerializer x$27 = this.createNewProducer$default$11();
        ByteArraySerializer x$28 = this.createNewProducer$default$12();
        return this.createNewProducer(x$16, x$18, x$20, x$21, x$17, x$22, x$23, x$24, x$25, x$26, (Serializer)x$27, (Serializer)x$28, (Option<Properties>)x$19);
    }

    public int createTransactionalProducer$default$3() {
        return 16384;
    }

    public long createTransactionalProducer$default$4() {
        return 60000L;
    }

    /*
     * WARNING - void declaration
     */
    public void seedTopicWithNumberedRecords(String topic, int numRecords, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        String x$104 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$105 = Integer.MAX_VALUE;
        int x$106 = -1;
        Some x$107 = new Some((Object)props);
        long x$108 = this.createNewProducer$default$3();
        long x$109 = this.createNewProducer$default$4();
        long x$110 = this.createNewProducer$default$6();
        long x$111 = this.createNewProducer$default$7();
        SecurityProtocol x$112 = this.createNewProducer$default$8();
        Option<File> x$113 = this.createNewProducer$default$9();
        Option<Properties> x$114 = this.createNewProducer$default$10();
        ByteArraySerializer x$115 = this.createNewProducer$default$11();
        ByteArraySerializer x$116 = this.createNewProducer$default$12();
        KafkaProducer producer = this.createNewProducer(x$104, x$106, x$108, x$109, x$105, x$110, x$111, x$112, x$113, x$114, (Serializer)x$115, (Serializer)x$116, (Option<Properties>)x$107);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(topic, producer){
                public static final long serialVersionUID = 0L;
                private final String topic$5;
                private final KafkaProducer producer$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(new ProducerRecord(this.topic$5, (Object)TestUtils$.MODULE$.kafka$utils$TestUtils$$asBytes(((Object)BoxesRunTime.boxToInteger((int)i)).toString()), (Object)TestUtils$.MODULE$.kafka$utils$TestUtils$$asBytes(((Object)BoxesRunTime.boxToInteger((int)i)).toString())));
                }
                {
                    this.topic$5 = topic$5;
                    this.producer$2 = producer$2;
                }
            });
            producer.flush();
        }
        catch (Throwable throwable) {
            void var5_18;
            var5_18.close();
            throw throwable;
        }
        producer.close();
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] kafka$utils$TestUtils$$asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = JavaConversions$.MODULE$.iterableAsScalaIterable(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Header header = (Header)some.x();
            Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " but expected the value to indicate "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asString(header.value())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed status."})).s((Seq)Nil$.MODULE$)).toString(), (Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.recordValueAsString(record);
        }
        if (None$.MODULE$.equals(option)) {
            throw this.fail("expected the record header to include an expected transaction status, but received nothing.");
        }
        throw new MatchError((Object)option);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                return this.willBeCommitted$1 ? TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue() : TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, null, (Object)key, (Object)value, (java.lang.Iterable)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{header}))));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, this.kafka$utils$TestUtils$$asBytes(key), this.kafka$utils$TestUtils$$asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(consumer.assignment()).foreach((Function1)new Serializable(consumer, offsetsToCommit){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$3;
            private final HashMap offsetsToCommit$1;

            public final Option<OffsetAndMetadata> apply(TopicPartition topicPartition) {
                return this.offsetsToCommit$1.put((Object)topicPartition, (Object)new OffsetAndMetadata(this.consumer$3.position(topicPartition)));
            }
            {
                this.consumer$3 = consumer$3;
                this.offsetsToCommit$1 = offsetsToCommit$1;
            }
        });
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> pollUntilAtLeastNumRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        void var3_3;
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final int numRecords$1;
            private final ArrayBuffer records$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$3.$plus$plus$eq((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)this.consumer$2.poll(50L)));
                return this.records$3.size() >= this.numRecords$1;
            }
            {
                this.consumer$2 = consumer$2;
                this.numRecords$1 = numRecords$1;
                this.records$3 = records$3;
            }
        }, (Function0<String>)new Serializable(numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final int numRecords$1;
            private final ArrayBuffer records$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$3.size()), BoxesRunTime.boxToInteger((int)this.numRecords$1)}));
            }
            {
                this.numRecords$1 = numRecords$1;
                this.records$3 = records$3;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4());
        return var3_3;
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        JavaConversions$.MODULE$.asScalaSet(consumer.assignment()).foreach((Function1)new Serializable(consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;

            public final void apply(TopicPartition x0$1) {
                BoxedUnit boxedUnit;
                TopicPartition topicPartition = x0$1;
                OffsetAndMetadata offset = this.consumer$4.committed(topicPartition);
                if (offset == null) {
                    this.consumer$4.seekToBeginning(Collections.singletonList(topicPartition));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.consumer$4.seek(topicPartition, offset.offset());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.consumer$4 = consumer$4;
            }
        });
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
            return out.toString();
        }
        finally {
            Console$.MODULE$.out().flush();
        }
    }

    private final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol protocol$2;

            public final boolean apply(SecurityProtocol x$4) {
                SecurityProtocol securityProtocol = x$4;
                SecurityProtocol securityProtocol2 = this.protocol$2;
                return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
            }
            {
                this.protocol$2 = protocol$2;
            }
        }));
    }

    public final Seq kafka$utils$TestUtils$$subPaths$1(String path, ZkUtils zkUtils$11) {
        Seq seq;
        if (zkUtils$11.pathExists(path)) {
            String string = path;
            seq = (Seq)((SeqLike)((TraversableLike)zkUtils$11.getChildren(path).map((Function1)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final String path$1;

                public final String apply(String c) {
                    return new StringBuilder().append((Object)this.path$1).append((Object)"/").append((Object)c).toString();
                }
                {
                    this.path$1 = path$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(zkUtils$11){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$11;

                public final Seq<String> apply(String path) {
                    return TestUtils$.MODULE$.kafka$utils$TestUtils$$subPaths$1(path, this.zkUtils$11);
                }
                {
                    this.zkUtils$11 = zkUtils$11;
                }
            }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public final void kafka$utils$TestUtils$$failWithTimeout$1(String message$2, int timeoutMs$2) {
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Timed out, the concurrent functions took more than ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message$2, BoxesRunTime.boxToInteger((int)timeoutMs$2)})));
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.MockZkPort = 1;
        this.MockZkConnect = new StringBuilder().append((Object)"127.0.0.1:").append((Object)BoxesRunTime.boxToInteger((int)this.MockZkPort())).toString();
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    }
}

