/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import kafka.common.MessageFormatter;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.BaseConsumerRecord$;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\"g\"|W\u000f\u001c3MS6LGOU3bIN$v.T1y\u001b\u0016\u001c8/Y4f\u0019&l\u0017\u000e\u001e\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011A\u000b\u0002GMDw.\u001e7e'R|\u0007o\u00165f]>+H\u000f];u\u0007\",7m[#se>\u0014h)Y5mg\"\u0012!E\u0007\u0005\u0006M\u0001!\t!F\u0001'g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012|E\u000eZ\"p]N,X.\u001a:WC2LGmQ8oM&<\u0007FA\u0013\u001b\u0011\u0015I\u0003\u0001\"\u0001\u0016\u0003\u0019\u001a\bn\\;mIB\u000b'o]3WC2LGMT3x\u0007>t7/^7feZ\u000bG.\u001b3D_:4\u0017n\u001a\u0015\u0003QiAQ\u0001\f\u0001\u0005\u0002U\tQh\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3OK^\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRDg*^7fe&\u001cwJ\u001a4tKRD#a\u000b\u000e\t\u000b=\u0002A\u0011A\u000b\u0002'Q,7\u000f\u001e#fM\u0006,H\u000e^\"p]N,X.\u001a:)\u00059R\u0002\"\u0002\u001a\u0001\t\u0003)\u0012\u0001P:i_VdG\rU1sg\u00164\u0016\r\\5e\u001d\u0016<8+[7qY\u0016\u001cuN\\:v[\u0016\u0014h+\u00197jI\u000e{gNZ5h/&$\bn\u0015;sS:<wJ\u001a4tKRD#!\r\u000e\t\u000bU\u0002A\u0011A\u000b\u00025MDw.\u001e7e!\u0006\u00148/Z\"p]\u001aLwm\u001d$s_64\u0015\u000e\\3)\u0005QR\u0002")
public class ConsoleConsumerTest {
    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        String x$1 = "foo";
        int x$2 = 1;
        long x$3 = 1L;
        byte[] x$4 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$5 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$6 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$7 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        Headers x$8 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$8();
        BaseConsumerRecord record = new BaseConsumerRecord(x$1, x$2, x$3, x$6, x$7, x$4, x$5, x$8);
        int messageLimit = 10;
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(messageLimit);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record).times(messageLimit);
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)EasyMock.createNiceMock(PrintStream.class);
        String x$9 = "foo";
        int x$10 = 1;
        long x$11 = 1L;
        byte[] x$12 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$13 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$14 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$15 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        Headers x$16 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$8();
        BaseConsumerRecord record = new BaseConsumerRecord(x$9, x$10, x$11, x$14, x$15, x$12, x$13, x$16);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record);
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.eq((Object)printStream));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        EasyMock.replay((Object[])new Object[]{printStream});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        EasyMock.verify((Object[])new Object[]{consumer, formatter, printStream});
    }

    @Test
    public void shouldParseValidOldConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)3L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void testDefaultConsumer() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--new-consumer", "--property", "print.value=false"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("request.timeout.ms=1000".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
    }
}

