/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Before;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0001\u0003\u0003\u00039!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u00045\t!F\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111!\u00138u\u0011\u001di\u0002A1A\u0007\u0002U\tQbY8ogVlWM]\"pk:$\bbB\u0010\u0001\u0005\u00045\t!F\u0001\fg\u0016\u0014h/\u001a:D_VtG\u000f\u0003\u0005\"\u0001!\u0015\r\u0011\"\u0001#\u00039\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA!\u001e;jY*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\tY\u0001A\t\u0011)Q\u0005G\u0005y\u0001O]8ek\u000e,'oQ8oM&<\u0007\u0005\u0003\u0005/\u0001!\u0015\r\u0011\"\u0001#\u00039\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001eD\u0001\u0002\r\u0001\t\u0002\u0003\u0006KaI\u0001\u0010G>t7/^7fe\u000e{gNZ5hA!A!\u0007\u0001EC\u0002\u0013\u0005!%\u0001\u0007tKJ4XM]\"p]\u001aLw\r\u0003\u00055\u0001!\u0005\t\u0015)\u0003$\u00035\u0019XM\u001d<fe\u000e{gNZ5hA!9a\u0007\u0001b\u0001\n\u00039\u0014!C2p]N,X.\u001a:t+\u0005A\u0004cA\u001d?\u00016\t!H\u0003\u0002<y\u00059Q.\u001e;bE2,'BA\u001f\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u0012aAQ;gM\u0016\u0014\b\u0003B!L\u001b6k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001bY8ogVlWM\u001d\u0006\u0003\u000b\u001a\u000bqa\u00197jK:$8O\u0003\u0002\u0006\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\ta%IA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0004/9\u0003\u0016BA(\u0019\u0005\u0015\t%O]1z!\t9\u0012+\u0003\u0002S1\t!!)\u001f;f\u0011\u0019!\u0006\u0001)A\u0005q\u0005Q1m\u001c8tk6,'o\u001d\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006I\u0001O]8ek\u000e,'o]\u000b\u00021B\u0019\u0011HP-\u0011\tikV*T\u0007\u00027*\u0011A\fR\u0001\taJ|G-^2fe&\u0011al\u0017\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\r\u0001\u0004\u0001\u0015!\u0003Y\u0003)\u0001(o\u001c3vG\u0016\u00148\u000f\t\u0005\u0006E\u0002!\teY\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\rE\u0002f[Bt!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%4\u0011A\u0002\u001fs_>$h(C\u0001\u001a\u0013\ta\u0007$A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011A\u000e\u0007\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0012\taa]3sm\u0016\u0014\u0018BA;s\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b]\u0004A\u0011\t=\u0002\u000bM,G/\u00169\u0015\u0003e\u0004\"a\u0006>\n\u0005mD\"\u0001B+oSRD#A^?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!S\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u000by(A\u0002\"fM>\u0014X\rC\u0004\u0002\n\u0001!\t!a\u0003\u0002#\r\u0014X-\u0019;f\u001d\u0016<\bK]8ek\u000e,'/F\u0001Z\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\t\u0011c\u0019:fCR,g*Z<D_:\u001cX/\\3s+\u0005\u0001\u0005BBA\u000b\u0001\u0011\u0005\u00030\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t\u0019\"!\u0007\u0011\u0007y\fY\"C\u0002\u0002\u001e}\u0014Q!\u00114uKJ\u0004")
public abstract class IntegrationTestHarness
extends KafkaServerTestHarness {
    private Properties producerConfig;
    private Properties consumerConfig;
    private Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        IntegrationTestHarness integrationTestHarness = this;
        synchronized (integrationTestHarness) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    private Properties consumerConfig$lzycompute() {
        IntegrationTestHarness integrationTestHarness = this;
        synchronized (integrationTestHarness) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    private Properties serverConfig$lzycompute() {
        IntegrationTestHarness integrationTestHarness = this;
        synchronized (integrationTestHarness) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    public abstract int producerCount();

    public abstract int consumerCount();

    public abstract int serverCount();

    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$4 = this.serverCount();
        String x$5 = this.zkConnect();
        Some x$6 = new Some((Object)this.securityProtocol());
        Option<File> x$7 = this.trustStoreFile();
        Option<Properties> x$8 = this.serverSaslProperties();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$4, x$5, x$9, x$10, (Option<SecurityProtocol>)x$6, x$7, x$8, x$11, x$12, x$13, x$14, x$15);
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegrationTestHarness $outer;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
                config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
                config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.$outer.listenerName().value());
                return config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), this.$outer.securityProtocol().name})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegrationTestHarness $outer;

            public final void apply(Properties x$1) {
                x$1.putAll((java.util.Map<?, ?>)this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Seq)cfgs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        Properties producerSecurityProps = TestUtils$.MODULE$.producerSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        Properties consumerSecurityProps = TestUtils$.MODULE$.consumerSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        super.setUp();
        this.producerConfig().put("key.serializer", ByteArraySerializer.class);
        this.producerConfig().put("value.serializer", ByteArraySerializer.class);
        this.producerConfig().putAll((java.util.Map<?, ?>)producerSecurityProps);
        this.consumerConfig().put("key.deserializer", ByteArrayDeserializer.class);
        this.consumerConfig().put("value.deserializer", ByteArrayDeserializer.class);
        this.consumerConfig().putAll((java.util.Map<?, ?>)consumerSecurityProps);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.producerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegrationTestHarness $outer;

            public final Buffer<KafkaProducer<byte[], byte[]>> apply(int _) {
                return this.$outer.producers().$plus$eq(this.$outer.createNewProducer());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.consumerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IntegrationTestHarness $outer;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                return this.$outer.consumers().$plus$eq(this.$outer.createNewConsumer());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createOffsetsTopic(this.zkUtils(), (Seq<KafkaServer>)this.servers());
    }

    public KafkaProducer<byte[], byte[]> createNewProducer() {
        String x$16 = this.brokerList();
        SecurityProtocol x$17 = this.securityProtocol();
        Option<File> x$18 = this.trustStoreFile();
        Option<Properties> x$19 = this.clientSaslProperties();
        Some x$20 = new Some((Object)this.producerConfig());
        int x$21 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$22 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$23 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$24 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$25 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$26 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$27 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$28 = TestUtils$.MODULE$.createNewProducer$default$12();
        return TestUtils$.MODULE$.createNewProducer(x$16, x$21, x$22, x$23, x$24, x$25, x$26, x$17, x$18, x$19, x$27, x$28, (Option<Properties>)x$20);
    }

    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        String x$29 = this.brokerList();
        SecurityProtocol x$30 = this.securityProtocol();
        Option<File> x$31 = this.trustStoreFile();
        Option<Properties> x$32 = this.clientSaslProperties();
        Some x$33 = new Some((Object)this.consumerConfig());
        String x$34 = TestUtils$.MODULE$.createNewConsumer$default$2();
        String x$35 = TestUtils$.MODULE$.createNewConsumer$default$3();
        long x$36 = TestUtils$.MODULE$.createNewConsumer$default$4();
        String x$37 = TestUtils$.MODULE$.createNewConsumer$default$5();
        int x$38 = TestUtils$.MODULE$.createNewConsumer$default$6();
        return TestUtils$.MODULE$.createNewConsumer(x$29, x$34, x$35, x$36, x$37, x$38, x$30, x$31, x$32, (Option<Properties>)x$33);
    }

    @Override
    @After
    public void tearDown() {
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$3) {
                x$3.close();
            }
        });
        super.tearDown();
    }
}

