/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5c!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]AZ\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ$G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005qjT\"\u0001\u0002\n\u0005y\u0012!a\u0001'pO\"A\u0001\t\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005C\u0001\u001f\u0001\u0011\u0015Q\u0012\t1\u0001\u001e\u0011\u0015Y\u0013\t1\u0001.\u0011\u001dA\u0005A1A\u0005B%\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005Q\u0005CA&O\u001b\u0005a%BA'%\u0003\u0011a\u0017M\\4\n\u0005=c%AB*ue&tw\r\u0003\u0004R\u0001\u0001\u0006IAS\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005T\u0001\t\u0007I\u0011\u0001\u0002J\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1Q\u000b\u0001Q\u0001\n)\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004X\u0001\t\u0007I\u0011\u0002-\u0002\u0017\rDWmY6q_&tGo]\u000b\u00023B!!l\u0018\u0011b\u001b\u0005Y&B\u0001/^\u0003%IW.\\;uC\ndWM\u0003\u0002_\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&aA'baB\u0011!MZ\u0007\u0002G*\u0011q\u000b\u001a\u0006\u0003K\u0012\taa]3sm\u0016\u0014\u0018BA4d\u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\"1\u0011\u000e\u0001Q\u0001\ne\u000bAb\u00195fG.\u0004x.\u001b8ug\u0002Bqa\u001b\u0001C\u0002\u0013%A.\u0001\u0006j]B\u0013xn\u001a:fgN,\u0012!\u001c\t\u0005]F\u00044/D\u0001p\u0015\t\u0001X,A\u0004nkR\f'\r\\3\n\u0005I|'a\u0002%bg\"l\u0015\r\u001d\t\u0003yQL!!\u001e\u0002\u0003!1{wm\u00117fC:LgnZ*uCR,\u0007BB<\u0001A\u0003%Q.A\u0006j]B\u0013xn\u001a:fgN\u0004\u0003bB=\u0001\u0005\u0004%IA_\u0001\u0005Y>\u001c7.F\u0001|!\ra\u0018qA\u0007\u0002{*\u0011ap`\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0002%\u0003\u0011)H/\u001b7\n\u0007\u0005%QPA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003|\u0003\u0015awnY6!\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\"\u0001\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$WCAA\u000b!\ra\u0018qC\u0005\u0004\u00033i(!C\"p]\u0012LG/[8o\u0011!\ti\u0002\u0001Q\u0001\n\u0005U\u0011a\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012\u0004\u0003\"CA\u0011\u0001\u0001\u0007I\u0011BA\u0012\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\u0005\u0015\u0002c\u0001\u0005\u0002(%\u0019\u0011\u0011F\u0005\u0003\r\u0011{WO\u00197f\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty#A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\u0011\t\t$a\u000e\u0011\u0007!\t\u0019$C\u0002\u00026%\u0011A!\u00168ji\"Q\u0011\u0011HA\u0016\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u0013\u0003i!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8!Q\u0011\tY$!\u0011\u0011\u0007!\t\u0019%C\u0002\u0002F%\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017\nQ\u0002^5nK>3G*Y:u%VtWCAA'!\rA\u0011qJ\u0005\u0004\u0003#J!\u0001\u0002'p]\u001eD\u0011\"!\u0016\u0001\u0001\u0004%I!a\u0016\u0002#QLW.Z(g\u0019\u0006\u001cHOU;o?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005e\u0003BCA\u001d\u0003'\n\t\u00111\u0001\u0002N!A\u0011Q\f\u0001!B\u0013\ti%\u0001\buS6,wJ\u001a'bgR\u0014VO\u001c\u0011)\t\u0005m\u0013\u0011\t\u0005\b\u0003G\u0002A\u0011AA3\u0003U\tG\u000e\\\"mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!a\u001a\u0011\u000f\u0005%\u0014q\u000e\u0019\u0002N9\u0019\u0001\"a\u001b\n\u0007\u00055\u0014\"\u0001\u0004Qe\u0016$WMZ\u0005\u0004A\u0006E$bAA7\u0013!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014!G4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$B!!\u001f\u0002\u0006B)\u0001\"a\u001f\u0002\u0000%\u0019\u0011QP\u0005\u0003\r=\u0003H/[8o!\ra\u0014\u0011Q\u0005\u0004\u0003\u0007\u0013!A\u0003'pOR{7\t\\3b]\"A\u0011qQA:\u0001\u0004\tI)\u0001\u0003uS6,\u0007\u0003BAF\u0003\u001fk!!!$\u000b\u0005A\u0011\u0014\u0002BAI\u0003\u001b\u0013A\u0001V5nK\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015!\u00043fY\u0016$\u0018M\u00197f\u0019><7\u000f\u0006\u0002\u0002\u001aB1\u00111TAV\u0003csA!!(\u0002(:!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$n\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0006\n\u0007\u0005%\u0016\"A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0016q\u0016\u0002\t\u0013R,'/\u00192mK*\u0019\u0011\u0011V\u0005\u0011\u000b!\t\u0019\fM\u001e\n\u0007\u0005U\u0016B\u0001\u0004UkBdWM\r\u0005\b\u0003s\u0003A\u0011AA^\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011\u0011GA_\u0011\u001d\ty,a.A\u0002A\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002D\u0002!\t!!2\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011\u0011GAd\u0011\u001d\ty,!1A\u0002ABq!a3\u0001\t\u0003\ti-\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\t\u0005E\u0012q\u001a\u0005\b\u0003\u007f\u000bI\r1\u00011\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+\f\u0011#[:DY\u0016\fg.\u001b8h\u0013:\u001cF/\u0019;f)\u0019\t9.!8\u0002`B\u0019\u0001\"!7\n\u0007\u0005m\u0017BA\u0004C_>dW-\u00198\t\u000f\u0005}\u0016\u0011\u001ba\u0001a!9\u0011\u0011]Ai\u0001\u0004\u0019\u0018!D3ya\u0016\u001cG/\u001a3Ti\u0006$X\rC\u0004\u0002f\u0002!\t!a:\u0002)\rDWmY6DY\u0016\fg.\u001b8h\u0003\n|'\u000f^3e)\u0011\t\t$!;\t\u000f\u0005}\u00161\u001da\u0001a!9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR1\u0011\u0011GAy\u0003kDq!a=\u0002l\u0002\u0007\u0001%A\u0004eCR\fG)\u001b:\t\u0011\u0005]\u00181\u001ea\u0001\u0003s\fa!\u001e9eCR,\u0007#\u0002\u0005\u0002|\u0005m\bC\u0002\u0005\u00024B\ni\u0005C\u0004\u0002\u0000\u0002!\tA!\u0001\u0002/5\f\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$H\u0003CA\u0019\u0005\u0007\u0011)Aa\u0002\t\u000f\u0005M\u0018Q a\u0001A!9\u0011qXA\u007f\u0001\u0004\u0001\u0004\u0002\u0003B\u0005\u0003{\u0004\r!!\u0014\u0002\r=4gm]3u\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\tA\u0002Z8oK\u000ecW-\u00198j]\u001e$\u0002\"!\r\u0003\u0012\tM!Q\u0003\u0005\b\u0003\u007f\u0013Y\u00011\u00011\u0011\u001d\t\u0019Pa\u0003A\u0002\u0001B\u0001Ba\u0006\u0003\f\u0001\u0007\u0011QJ\u0001\nK:$wJ\u001a4tKRDqAa\u0007\u0001\t\u0003\u0011i\"\u0001\u0007e_:,G)\u001a7fi&tw\r\u0006\u0003\u00022\t}\u0001bBA`\u00053\u0001\r\u0001M\u0004\t\u0005G\u0011\u0001\u0012\u0001\u0002\u0003&\u0005\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0007q\u00129CB\u0004\u0002\u0005!\u0005!A!\u000b\u0014\t\t\u001dr!\u0004\u0005\b\u0005\n\u001dB\u0011\u0001B\u0017)\t\u0011)\u0003\u0003\u0005\u00032\t\u001dB\u0011\u0001B\u001a\u0003II7oQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3\u0015\t\u0005]'Q\u0007\u0005\u0007\u0007\t=\u0002\u0019A\u001e\t\u0011\te\"q\u0005C\u0001\u0005w\t\u0001c\u00197fC:\f'\r\\3PM\u001a\u001cX\r^:\u0015\u0015\tu\"q\bB!\u0005\u0007\u0012I\u0005E\u0004\t\u0003g\u000bi%!\u0014\t\r\r\u00119\u00041\u0001<\u0011\u001d\tyLa\u000eA\u0002AB\u0001B!\u0012\u00038\u0001\u0007!qI\u0001\nY\u0006\u001cHo\u00117fC:\u0004RAW01\u0003\u001bB\u0001Ba\u0013\u00038\u0001\u0007\u0011QJ\u0001\u0004]><\b")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    public void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.kafka$log$LogCleanerManager$$checkpoints().values().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<TopicPartition, Object> apply(OffsetCheckpointFile x$1) {
                return x$1.read();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final Time time$1;

            public final Option<LogToClean> apply() {
                None$ none$;
                long now = this.time$1.milliseconds();
                this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$1) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log = (Log)tuple2._2();
                            boolean bl = log.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestCompactedLog$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$2) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).map((Function1)new Serializable(this, now, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicPartition, Log> x0$3) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            Log log = (Log)tuple2._2();
                            Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, (scala.collection.immutable.Map<TopicPartition, Object>)this.lastClean$1, this.now$1);
                            if (tuple22 != null) {
                                Tuple2.mcJJ.sp sp2;
                                long firstDirtyOffset = tuple22._1$mcJ$sp();
                                long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                                Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                                return logToClean;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.now$1 = now$1;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                    none$ = new Some((Object)filthiest);
                }
                return none$;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicPartition, Log>> apply() {
                void var1_1;
                Iterable toClean = (Iterable)this.$outer.logs().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$4) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            Log log = (Log)tuple2._2();
                            boolean bl = !this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                toClean.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final Option<LogCleaningState> apply(Tuple2<TopicPartition, Log> x0$5) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Option option = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicPartition$1);
                this.$outer.resumeCleaning(this.topicPartition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        });
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option;
                block7: {
                    LogCleaningState logCleaningState;
                    block8: {
                        block6: {
                            Option option2;
                            Option option3;
                            block5: {
                                option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$3);
                                if (!None$.MODULE$.equals(option)) break block5;
                                option3 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$3, (Object)LogCleaningPaused$.MODULE$);
                                break block6;
                            }
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            LogCleaningState state = (LogCleaningState)some.x();
                            logCleaningState = state;
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block8;
                            option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$3, (Object)LogCleaningAborted$.MODULE$);
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$3, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3}));
            }
            {
                this.topicPartition$3 = topicPartition$3;
            }
        });
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$4;

            public final Option<LogCleaningState> apply() {
                Option option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$4);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$4})));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogCleaningState state = (LogCleaningState)some.x();
                    LogCleaningState logCleaningState = state;
                    if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                        Option option2;
                        Option option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$4);
                        return option3;
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$4, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$4}));
            }
            {
                this.topicPartition$4 = topicPartition$4;
            }
        });
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get((Object)topicPartition);
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$5, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$5 = topicPartition$5;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, update2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$1);
                Map existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.update$1));
                checkpoint.write((Map<TopicPartition, Object>)existing);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, topicPartition, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicPartition topicPartition$2;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpointFile checkpoint;
                Map<TopicPartition, Object> existing;
                if (this.$outer.logs().get(this.topicPartition$2).config().compact() && BoxesRunTime.unboxToLong((Object)(existing = (checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$2)).read()).getOrElse((Object)this.topicPartition$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$2), (Object)BoxesRunTime.boxToLong((long)this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicPartition$2 = topicPartition$2;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$6;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                LogCleaningState logCleaningState;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            logCleaningState = (LogCleaningState)this.$outer.kafka$log$LogCleanerManager$$inProgress().apply((Object)this.topicPartition$6);
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block2;
                            this.$outer.updateCheckpoints(this.dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition$6, (Object)BoxesRunTime.boxToLong((long)this.endOffset$1))));
                            boxedUnit = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$6);
                            break block3;
                        }
                        if (!LogCleaningAborted$.MODULE$.equals(logCleaningState)) break block4;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$6, (Object)LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$6, logCleaningState})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$6 = topicPartition$6;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$7;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$7 = topicPartition$7;
            }
        });
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Tuple2<File, OffsetCheckpointFile> apply(File dir) {
                return new Tuple2((Object)dir, (Object)new OffsetCheckpointFile(new File(dir, this.$outer.offsetCheckpointFile())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

