/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetMap;
import kafka.log.ProducerIdEntry;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TransactionIndex;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005b\u0002.\u0001\u0005\u0004%\teW\u0001\u000bY><w-\u001a:OC6,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDa!\u001a\u0001!\u0002\u0013a\u0016a\u00037pO\u001e,'OT1nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f1A\\5p\u0013\tq7N\u0001\u0006CsR,')\u001e4gKJDq\u0001\u001d\u0001A\u0002\u0013%\u0011/\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005)\u0013\bbB:p\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004BB;\u0001A\u0003&\u0011.A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003bB<\u0001\u0001\u0004%I\u0001[\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\u0002\u001f]\u0014\u0018\u000e^3Ck\u001a4WM]0%KF$\"AS>\t\u000fMD\u0018\u0011!a\u0001S\"1Q\u0010\u0001Q!\n%\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u001cI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0001(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u001b\t9A\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0007\tA\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005\u0003\u0005\u0002\u0016\u0001!\tAAA\f\u0003\u0015\u0019G.Z1o)\u0011\tI\"a\u000b\u0011\u000f!\tY\"a\b\u0002&%\u0019\u0011QD\u0005\u0003\rQ+\b\u000f\\33!\rA\u0011\u0011E\u0005\u0004\u0003GI!\u0001\u0002'p]\u001e\u00042\u0001IA\u0014\u0013\r\tIC\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\t\u0003[\t\u0019\u00021\u0001\u00020\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004A\u0005E\u0012bAA\u001a\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005]\u0002\u0001\"\u0001\u0003\u0003s\tq\u0001Z8DY\u0016\fg\u000e\u0006\u0004\u0002\u001a\u0005m\u0012Q\b\u0005\t\u0003[\t)\u00041\u0001\u00020!A\u0011qHA\u001b\u0001\u0004\ty\"A\beK2,G/\u001a%pe&TxN\\'t\u0011!\t\u0019\u0005\u0001C\u0001\u0005\u0005\u0015\u0013!D2mK\u0006t7+Z4nK:$8\u000fF\u0006K\u0003\u000f\ny%!\u001d\u0002v\u0005]\u0004bB\u0002\u0002B\u0001\u0007\u0011\u0011\n\t\u0004A\u0005-\u0013bAA'\u0005\t\u0019Aj\\4\t\u0011\u0005E\u0013\u0011\ta\u0001\u0003'\n\u0001b]3h[\u0016tGo\u001d\t\u0007\u0003+\n)'a\u001b\u000f\t\u0005]\u0013\u0011\r\b\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0011bAA2\u0013\u00059\u0001/Y2lC\u001e,\u0017\u0002BA4\u0003S\u00121aU3r\u0015\r\t\u0019'\u0003\t\u0004A\u00055\u0014bAA8\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005M\u0014\u0011\ta\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005}\u0012\u0011\ta\u0001\u0003?A\u0001\"!\u001f\u0002B\u0001\u0007\u0011QE\u0001\u0006gR\fGo\u001d\u0005\t\u0003{\u0002A\u0011\u0001\u0002\u0002\u0000\u0005I1\r\\3b]&sGo\u001c\u000b\u0014\u0015\u0006\u0005\u0015QQAE\u0003\u001b\u000by)!'\u0002\u001e\u0006\u001d\u0016q\u0018\u0005\b\u0003\u0007\u000bY\b1\u0001G\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\"\u0002|\u0001\u0007\u00111N\u0001\u0007g>,(oY3\t\u0011\u0005-\u00151\u0010a\u0001\u0003W\nA\u0001Z3ti\"9\u00111OA>\u0001\u0004y\u0002\u0002CAI\u0003w\u0002\r!a%\u0002\u001bI,G/Y5o\t\u0016dW\r^3t!\rA\u0011QS\u0005\u0004\u0003/K!a\u0002\"p_2,\u0017M\u001c\u0005\b\u00037\u000bY\b1\u0001\u0018\u0003Ei\u0017\r\u001f'pO6+7o]1hKNK'0\u001a\u0005\t\u0003?\u000bY\b1\u0001\u0002\"\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019\u0001%a)\n\u0007\u0005\u0015&A\u0001\u000eDY\u0016\fg.\u001a3Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002*\u0006m\u0004\u0019AAV\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001c\b\u0003CAW\u0003g\u000by\"!/\u000f\u0007!\ty+C\u0002\u00022&\ta\u0001\u0015:fI\u00164\u0017\u0002BA[\u0003o\u00131!T1q\u0015\r\t\t,\u0003\t\u0004A\u0005m\u0016bAA_\u0005\ty\u0001K]8ek\u000e,'/\u00133F]R\u0014\u0018\u0010\u0003\u0005\u0002z\u0005m\u0004\u0019AA\u0013\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b\f!c\u001d5pk2$G)[:dCJ$')\u0019;dQRA\u00111SAd\u0003#\f\u0019\u000e\u0003\u0005\u0002J\u0006\u0005\u0007\u0019AAf\u0003\u0015\u0011\u0017\r^2i!\u0011\t)!!4\n\t\u0005=\u0017q\u0001\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000e\u0003\u0005\u0002 \u0006\u0005\u0007\u0019AAQ\u0011!\t).!1A\u0002\u0005M\u0015\u0001\u0005:fi\u0006Lg\u000e\u0016=o\u001b\u0006\u00148.\u001a:t\u0011\u001d\tI\u000e\u0001C\u0005\u00037\f!c\u001d5pk2$'+\u001a;bS:\u0014VmY8sIRq\u00111SAo\u0003?\f\t/a9\u0002f\u00065\b\u0002CAD\u0003/\u0004\r!a\u001b\t\u000f\u0005M\u0014q\u001ba\u0001?!A\u0011\u0011SAl\u0001\u0004\t\u0019\n\u0003\u0005\u0002J\u0006]\u0007\u0019AAf\u0011!\tI!a6A\u0002\u0005\u001d\b\u0003BA\u0003\u0003SLA!a;\u0002\b\t1!+Z2pe\u0012D\u0001\"!\u001f\u0002X\u0002\u0007\u0011Q\u0005\u0005\b\u0003c\u0004A\u0011AAz\u0003-9'o\\<Ck\u001a4WM]:\u0015\u0007)\u000b)\u0010C\u0004\u0002\u001c\u0006=\b\u0019A\f\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006q!/Z:u_J,')\u001e4gKJ\u001cH#\u0001&\t\u0011\u0005}\b\u0001\"\u0001\u0003\u0005\u0003\t1c\u001a:pkB\u001cVmZ7f]R\u001c()_*ju\u0016$\"Ba\u0001\u0003\n\tE!Q\u0003B\r!\u0019\t)F!\u0002\u0002T%!!qAA5\u0005\u0011a\u0015n\u001d;\t\u0011\u0005E\u0013Q a\u0001\u0005\u0017\u0001b!!\u0016\u0003\u000e\u0005-\u0014\u0002\u0002B\b\u0003S\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0005'\ti\u00101\u0001\u0018\u0003\u001di\u0017\r_*ju\u0016DqAa\u0006\u0002~\u0002\u0007q#\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0003\u0005\u0003\u001c\u0005u\b\u0019AA\u0010\u0003Y1\u0017N]:u+:\u001cG.Z1oC\ndWm\u00144gg\u0016$\bb\u0002B\u0010\u0001\u0011%!\u0011E\u0001\u001aY\u0006\u001cHo\u00144gg\u0016$hi\u001c:GSJ\u001cHoU3h[\u0016tG\u000f\u0006\u0004\u0002 \t\r\"\u0011\u0006\u0005\t\u0005K\u0011i\u00021\u0001\u0003(\u0005!1/Z4t!\u0019\t)F!\u0002\u0002l!A!1\u0004B\u000f\u0001\u0004\ty\u0002\u0003\u0005\u0003.\u0001!\tA\u0001B\u0018\u00039\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB$2B\u0013B\u0019\u0005g\u00119Da\u000f\u0003>!91Aa\u000bA\u0002\u0005%\u0003\u0002\u0003B\u001b\u0005W\u0001\r!a\b\u0002\u000bM$\u0018M\u001d;\t\u0011\te\"1\u0006a\u0001\u0003?\t1!\u001a8e\u0011\u001d\t\u0019Ha\u000bA\u0002}A\u0001\"!\u001f\u0003,\u0001\u0007\u0011Q\u0005\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003a\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB4uN]*fO6,g\u000e\u001e\u000b\u0011\u0003'\u0013)Ea\u0012\u0003L\t5#\u0011\u000bB*\u0005+Bq!a!\u0003@\u0001\u0007a\t\u0003\u0005\u0003J\t}\u0002\u0019AA6\u0003\u001d\u0019XmZ7f]RDq!a\u001d\u0003@\u0001\u0007q\u0004\u0003\u0005\u0003P\t}\u0002\u0019AA\u0010\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\u0005m%q\ba\u0001/!A\u0011q\u0014B \u0001\u0004\t\t\u000b\u0003\u0005\u0002z\t}\u0002\u0019AA\u0013\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            return this.doClean(cleanable, deleteHorizonMs);
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$13) {
                return x$13.lastModified();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.info((Function0<String>)new Serializable(this, deleteHorizonMs, log, cleanableHorizonMs){
            public static final long serialVersionUID = 0L;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final long cleanableHorizonMs$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$1.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
            }
            {
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
            }
        });
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1)new Serializable(this, deleteHorizonMs, log, stats){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final CleanerStats stats$2;

            public final void apply(Seq<LogSegment> group) {
                this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.stats$2 = stats$2;
            }
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        File timeIndexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).timeIndex().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        File txnIndexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).txnIndex().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        timeIndexFile.delete();
        txnIndexFile.delete();
        long startOffset = ((LogSegment)segments.head()).baseOffset();
        FileRecords records = FileRecords.open((File)logFile, (boolean)false, (int)log.initFileSize(), (boolean)Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, startOffset, ((LogSegment)segments.head()).index().maxIndexSize(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, startOffset, ((LogSegment)segments.head()).timeIndex().maxIndexSize(), TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(startOffset, txnIndexFile);
        LogSegment cleaned = new LogSegment(records, index, timeIndex, txnIndex, startOffset, ((LogSegment)segments.head()).indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment oldSegmentOpt = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset2 = oldSegmentOpt.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$14) {
                        return x$14.baseOffset();
                    }
                }).getOrElse((Function0)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMap map$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.map$2.latestOffset() + 1L;
                    }
                    {
                        this.map$2 = map$2;
                    }
                }));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset2, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, (Option<TransactionIndex>)new Some((Object)txnIndex));
                boolean retainDeletes = oldSegmentOpt.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)new Serializable(this, log, cleaned, oldSegmentOpt, startOffset2, retainDeletes){
                    public static final long serialVersionUID = 0L;
                    private final Log log$3;
                    private final LogSegment cleaned$1;
                    private final LogSegment oldSegmentOpt$1;
                    private final long startOffset$1;
                    private final boolean retainDeletes$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (largest timestamp %s) into %s, %s deletes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startOffset$1), this.log$3.name(), new Date(this.oldSegmentOpt$1.largestTimestamp()), BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                    }
                    {
                        this.log$3 = log$3;
                        this.cleaned$1 = cleaned$1;
                        this.oldSegmentOpt$1 = oldSegmentOpt$1;
                        this.startOffset$1 = startOffset$1;
                        this.retainDeletes$1 = retainDeletes$1;
                    }
                });
                this.cleanInto(log.topicPartition(), oldSegmentOpt, cleaned, map, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducers(), stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$15) {
                            return x$15.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            });
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegment source, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, ProducerIdEntry> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, source, map, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final LogSegment source$1;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1)new Serializable(this, batch){
                    public static final long serialVersionUID = 0L;
                    private final RecordBatch batch$1;

                    public final boolean apply(ProducerIdEntry x$16) {
                        return x$16.lastSeq() == this.batch$1.lastSequence();
                    }
                    {
                        this.batch$1 = batch$1;
                    }
                }) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record2) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.source$1, this.map$3, this.retainDeletes$2, batch, record2, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.source$1 = source$1;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead, result.bytesRead);
            stats.recopyMessages(result.messagesRetained, result.bytesRetained);
            position += result.bytesRead;
            ByteBuffer outputBuffer = result.output;
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(((RecordBatch)retained.batches().iterator().next()).baseOffset(), result.maxOffset, result.maxTimestamp, result.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result.messagesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(LogSegment source, OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record2.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record2.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record2.key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && record2.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record2.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append((Object)BoxesRunTime.boxToInteger((int)this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            int logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            int timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + ((LogSegment)segs.head()).size() <= maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() <= maxIndexSize && timeIndexSize + ((LogSegment)segs.head()).timeIndex().sizeInBytes() <= maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += ((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)new Serializable(this, log, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        });
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1)new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach((Function1)new Serializable(this, log, start, map, stats, dirty, transactionMetadata, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$2.topicPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$2.config().maxMessageSize()), this.transactionMetadata$2, this.stats$3);
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.dirty$1.indexOf((Object)this.segment$1)), BoxesRunTime.boxToLong((long)this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        });
    }

    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                int position = segment.index().lookup(startOffset).position();
                int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
                while (position < segment.log().sizeInBytes()) {
                    this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
                    this.kafka$log$Cleaner$$readBuffer().clear();
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                    MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
                    this.throttler.maybeThrottle(records.sizeInBytes());
                    int startPosition = position;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(this, map, startOffset, transactionMetadata, stats, maxDesiredMapSize, object){
                        public static final long serialVersionUID = 0L;
                        public final OffsetMap map$4;
                        public final long startOffset$2;
                        private final CleanedTransactionMetadata transactionMetadata$3;
                        public final CleanerStats stats$5;
                        public final int maxDesiredMapSize$1;
                        public final Object nonLocalReturnKey1$1;

                        public final void apply(MutableRecordBatch batch) {
                            if (batch.isControlBatch()) {
                                this.transactionMetadata$3.onControlBatchRead((RecordBatch)batch);
                                this.stats$5.indexMessagesRead(1);
                            } else {
                                boolean isAborted = this.transactionMetadata$3.onBatchRead((RecordBatch)batch);
                                if (isAborted) {
                                    this.stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                                } else {
                                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1 $outer;

                                        public final void apply(Record record2) {
                                            if (record2.hasKey() && record2.offset() >= this.$outer.startOffset$2) {
                                                if (this.$outer.map$4.size() < this.$outer.maxDesiredMapSize$1) {
                                                    this.$outer.map$4.put(record2.key(), record2.offset());
                                                } else {
                                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                                                }
                                            }
                                            this.$outer.stats$5.indexMessagesRead(1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                            }
                            if (batch.lastOffset() >= this.startOffset$2) {
                                this.map$4.updateLatestOffset(batch.lastOffset());
                            }
                        }
                        {
                            this.map$4 = map$4;
                            this.startOffset$2 = startOffset$2;
                            this.transactionMetadata$3 = transactionMetadata$3;
                            this.stats$5 = stats$5;
                            this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    int bytesRead = records.validBytes();
                    stats.indexBytesRead(bytesRead);
                    if ((position += bytesRead) != startPosition) continue;
                    this.growBuffers(maxLogMessageSize);
                }
                this.restoreBuffers();
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        });
    }
}

