/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KTableReduce<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final String storeName;
    private final Reducer<V> addReducer;
    private final Reducer<V> removeReducer;
    private boolean sendOldValues = false;

    KTableReduce(String storeName, Reducer<V> addReducer, Reducer<V> removeReducer) {
        this.storeName = storeName;
        this.addReducer = addReducer;
        this.removeReducer = removeReducer;
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        this.sendOldValues = true;
        return true;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableReduceProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableMaterializedValueGetterSupplier(this.storeName);
    }

    private class KTableReduceProcessor
    extends AbstractProcessor<K, Change<V>> {
        private TimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;

        private KTableReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (TimestampedKeyValueStore)context.getStateStore(KTableReduce.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, Change<V> value) {
            Object newAgg;
            long newTimestamp;
            Object intermediateAgg;
            if (key == null) {
                throw new StreamsException("Record key for KTable reduce operator with state " + KTableReduce.this.storeName + " should not be null.");
            }
            ValueAndTimestamp oldAggAndTimestamp = (ValueAndTimestamp)this.store.get(key);
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (value.oldValue != null && oldAgg != null) {
                intermediateAgg = KTableReduce.this.removeReducer.apply(oldAgg, value.oldValue);
                newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
            } else {
                intermediateAgg = oldAgg;
                newTimestamp = this.context().timestamp();
            }
            if (value.newValue != null) {
                if (intermediateAgg == null) {
                    newAgg = value.newValue;
                } else {
                    newAgg = KTableReduce.this.addReducer.apply(intermediateAgg, value.newValue);
                    newTimestamp = Math.max(this.context().timestamp(), oldAggAndTimestamp.timestamp());
                }
            } else {
                newAgg = intermediateAgg;
            }
            this.store.put(key, ValueAndTimestamp.make(newAgg, newTimestamp));
            this.tupleForwarder.maybeForward(key, newAgg, KTableReduce.this.sendOldValues ? oldAgg : null, newTimestamp);
        }
    }
}

