/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class MergedSortedCacheWindowStoreIterator<V>
extends AbstractMergedSortedCacheStoreIterator<Long, Long, V, byte[]>
implements WindowStoreIterator<V> {
    private final StateSerdes<Long, V> serdes;

    MergedSortedCacheWindowStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Long, byte[]> storeIterator, StateSerdes<Long, V> serdes) {
        super(cacheIterator, storeIterator);
        this.serdes = serdes;
    }

    @Override
    public KeyValue<Long, V> deserializeStorePair(KeyValue<Long, byte[]> pair) {
        return KeyValue.pair(pair.key, this.serdes.valueFrom((byte[])pair.value));
    }

    @Override
    Long deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = SegmentedCacheFunction.bytesFromCacheKey(cacheKey);
        return WindowStoreUtils.timestampFromBinaryKey(binaryKey);
    }

    @Override
    V deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return this.serdes.valueFrom(cacheEntry.value);
    }

    @Override
    public Long deserializeStoreKey(Long key) {
        return key;
    }

    @Override
    public int compare(Bytes cacheKey, Long storeKey) {
        byte[] binaryKey = SegmentedCacheFunction.bytesFromCacheKey(cacheKey);
        Long cacheTimestamp = WindowStoreUtils.timestampFromBinaryKey(binaryKey);
        return cacheTimestamp.compareTo(storeKey);
    }
}

