/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.TimeIndex;

public class LazyIndex<T extends AbstractIndex> {
    private final Lock lock = new ReentrantLock();
    private final long baseOffset;
    private final int maxIndexSize;
    private final IndexType indexType;
    private volatile IndexWrapper indexWrapper;

    private LazyIndex(IndexWrapper indexWrapper, long baseOffset, int maxIndexSize, IndexType indexType) {
        this.indexWrapper = indexWrapper;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.indexType = indexType;
    }

    public static LazyIndex<OffsetIndex> forOffset(File file, long baseOffset, int maxIndexSize) {
        return new LazyIndex<OffsetIndex>(new IndexFile(file), baseOffset, maxIndexSize, IndexType.OFFSET);
    }

    public static LazyIndex<TimeIndex> forTime(File file, long baseOffset, int maxIndexSize) {
        return new LazyIndex<TimeIndex>(new IndexFile(file), baseOffset, maxIndexSize, IndexType.TIME);
    }

    public File file() {
        return this.indexWrapper.file();
    }

    public T get() throws IOException {
        IndexWrapper wrapper = this.indexWrapper;
        if (wrapper instanceof IndexValue) {
            return (T)((IndexValue)wrapper).index;
        }
        this.lock.lock();
        try {
            if (this.indexWrapper instanceof IndexValue) {
                AbstractIndex abstractIndex = ((IndexValue)this.indexWrapper).index;
                return (T)abstractIndex;
            }
            if (this.indexWrapper instanceof IndexFile) {
                IndexValue<T> indexValue;
                IndexFile indexFile = (IndexFile)this.indexWrapper;
                this.indexWrapper = indexValue = new IndexValue<T>(this.loadIndex(indexFile.file));
                AbstractIndex abstractIndex = ((IndexValue)indexValue).index;
                return (T)abstractIndex;
            }
            throw new IllegalStateException("Unexpected type for indexWrapper " + this.indexWrapper.getClass());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateParentDir(File parentDir) {
        this.lock.lock();
        try {
            this.indexWrapper.updateParentDir(parentDir);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void renameTo(File f) throws IOException {
        this.lock.lock();
        try {
            this.indexWrapper.renameTo(f);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean deleteIfExists() throws IOException {
        this.lock.lock();
        try {
            boolean bl = this.indexWrapper.deleteIfExists();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            this.indexWrapper.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeHandler() {
        this.lock.lock();
        try {
            this.indexWrapper.closeHandler();
        }
        finally {
            this.lock.unlock();
        }
    }

    private T loadIndex(File file) throws IOException {
        switch (this.indexType) {
            case OFFSET: {
                return (T)new OffsetIndex(file, this.baseOffset, this.maxIndexSize, true);
            }
            case TIME: {
                return (T)new TimeIndex(file, this.baseOffset, this.maxIndexSize, true);
            }
        }
        throw new IllegalStateException("Unexpected indexType " + (Object)((Object)this.indexType));
    }

    private static class IndexValue<T extends AbstractIndex>
    implements IndexWrapper {
        private final T index;

        IndexValue(T index) {
            this.index = index;
        }

        @Override
        public File file() {
            return ((AbstractIndex)this.index).file();
        }

        @Override
        public void updateParentDir(File parentDir) {
            ((AbstractIndex)this.index).updateParentDir(parentDir);
        }

        @Override
        public void renameTo(File f) throws IOException {
            ((AbstractIndex)this.index).renameTo(f);
        }

        @Override
        public boolean deleteIfExists() throws IOException {
            return ((AbstractIndex)this.index).deleteIfExists();
        }

        @Override
        public void close() throws IOException {
            ((AbstractIndex)this.index).close();
        }

        @Override
        public void closeHandler() {
            ((AbstractIndex)this.index).closeHandler();
        }
    }

    private static class IndexFile
    implements IndexWrapper {
        private volatile File file;

        IndexFile(File file) {
            this.file = file;
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public void updateParentDir(File parentDir) {
            this.file = new File(parentDir, this.file.getName());
        }

        @Override
        public void renameTo(File f) throws IOException {
            try {
                Utils.atomicMoveWithFallback((Path)this.file.toPath(), (Path)f.toPath(), (boolean)false);
            }
            catch (NoSuchFileException e) {
                if (this.file.exists()) {
                    throw e;
                }
            }
            finally {
                this.file = f;
            }
        }

        @Override
        public boolean deleteIfExists() throws IOException {
            return Files.deleteIfExists(this.file.toPath());
        }

        @Override
        public void close() {
        }

        @Override
        public void closeHandler() {
        }
    }

    private static interface IndexWrapper
    extends Closeable {
        public File file();

        public void updateParentDir(File var1);

        public void renameTo(File var1) throws IOException;

        public boolean deleteIfExists() throws IOException;

        @Override
        public void close() throws IOException;

        public void closeHandler();
    }

    private static enum IndexType {
        OFFSET,
        TIME;

    }
}

