/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.List;
import java.util.Map;
import org.apache.kafka.server.util.Csv;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CsvTest {
    @Test
    public void testCsvMap() {
        Map emptyMap = Csv.parseCsvMap((String)"");
        Assertions.assertEquals(Map.of(), (Object)emptyMap);
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = Csv.parseCsvMap((String)kvPairsIpV6);
        for (Map.Entry entry : ipv6Map.entrySet()) {
            Assertions.assertEquals((Object)"a:b:c", entry.getKey());
            Assertions.assertEquals((Object)"v", entry.getValue());
        }
        String singleEntry = "key:value";
        Map singleMap = Csv.parseCsvMap((String)singleEntry);
        String value = (String)singleMap.get("key");
        Assertions.assertEquals((Object)"value", (Object)value);
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = Csv.parseCsvMap((String)kvPairsIpV4);
        for (Map.Entry entry : ipv4Map.entrySet()) {
            Assertions.assertEquals((Object)"192.168.2.1/30", entry.getKey());
            Assertions.assertEquals((Object)"allow", entry.getValue());
        }
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = Csv.parseCsvMap((String)kvPairsSpaces);
        for (Map.Entry entry : spaceMap.entrySet()) {
            Assertions.assertEquals((Object)"key", entry.getKey());
            Assertions.assertEquals((Object)"value", entry.getValue());
        }
    }

    @Test
    public void testCsvList() {
        List emptyList = Csv.parseCsvList((String)"");
        Assertions.assertEquals(List.of(), (Object)emptyList);
        List emptyListFromNullString = Csv.parseCsvList(null);
        Assertions.assertEquals(List.of(), (Object)emptyListFromNullString);
        List csvList = Csv.parseCsvList((String)"a,b ,c, d,,e,");
        Assertions.assertEquals(List.of("a", "b", "c", "d", "e"), (Object)csvList);
    }
}

