/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.record;

import java.util.Optional;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipCompression;
import org.apache.kafka.common.compress.Lz4Compression;
import org.apache.kafka.common.compress.SnappyCompression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerCompressionTypeTest {
    @Test
    public void testTargetCompressionType() {
        GzipCompression gzipWithLevel = Compression.gzip().level(CompressionType.GZIP.maxLevel()).build();
        Assertions.assertEquals((Object)gzipWithLevel, (Object)BrokerCompressionType.targetCompression(Optional.of(gzipWithLevel), (CompressionType)CompressionType.ZSTD));
        SnappyCompression snappy = Compression.snappy().build();
        Assertions.assertEquals((Object)snappy, (Object)BrokerCompressionType.targetCompression(Optional.of(snappy), (CompressionType)CompressionType.LZ4));
        Lz4Compression lz4WithLevel = Compression.lz4().level(CompressionType.LZ4.maxLevel()).build();
        Assertions.assertEquals((Object)lz4WithLevel, (Object)BrokerCompressionType.targetCompression(Optional.of(lz4WithLevel), (CompressionType)CompressionType.ZSTD));
        ZstdCompression zstdWithLevel = Compression.zstd().level(CompressionType.ZSTD.maxLevel()).build();
        Assertions.assertEquals((Object)zstdWithLevel, (Object)BrokerCompressionType.targetCompression(Optional.of(zstdWithLevel), (CompressionType)CompressionType.GZIP));
        GzipCompression gzip = Compression.gzip().build();
        Assertions.assertEquals((Object)gzip, (Object)BrokerCompressionType.targetCompression(Optional.empty(), (CompressionType)CompressionType.GZIP));
        Assertions.assertEquals((Object)snappy, (Object)BrokerCompressionType.targetCompression(Optional.empty(), (CompressionType)CompressionType.SNAPPY));
        Lz4Compression lz4 = Compression.lz4().build();
        Assertions.assertEquals((Object)lz4, (Object)BrokerCompressionType.targetCompression(Optional.empty(), (CompressionType)CompressionType.LZ4));
        ZstdCompression zstd = Compression.zstd().build();
        Assertions.assertEquals((Object)zstd, (Object)BrokerCompressionType.targetCompression(Optional.empty(), (CompressionType)CompressionType.ZSTD));
    }
}

