/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class FeatureTest {
    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testV0SupportedInEarliestMV(Feature feature) {
        Assertions.assertTrue((feature.featureVersions().length >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)MetadataVersion.MINIMUM_VERSION, (Object)feature.featureVersions()[0].bootstrapMetadataVersion());
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testFromFeatureLevelAllFeatures(Feature feature) {
        FeatureVersion[] featureImplementations = feature.featureVersions();
        short numFeatures = featureImplementations.length;
        short latestProductionLevel = feature.latestProduction();
        for (short i = 0; i < numFeatures; i = (short)(i + 1)) {
            short level = i;
            if (latestProductionLevel < i) {
                Assertions.assertEquals((Object)featureImplementations[i], (Object)feature.fromFeatureLevel(level, true));
                Assertions.assertThrows(IllegalArgumentException.class, () -> feature.fromFeatureLevel(level, false));
                continue;
            }
            Assertions.assertEquals((Object)featureImplementations[i], (Object)feature.fromFeatureLevel(level, false));
        }
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testValidateVersionAllFeatures(Feature feature) {
        for (FeatureVersion featureImpl : feature.featureVersions()) {
            HashMap<String, Short> deps = new HashMap<String, Short>();
            deps.putAll(featureImpl.dependencies());
            if (!deps.containsKey("metadata.version")) {
                deps.put("metadata.version", MetadataVersion.MINIMUM_VERSION.featureLevel());
            }
            Feature.validateVersion((FeatureVersion)featureImpl, deps);
        }
    }

    @Test
    public void testInvalidValidateVersion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateVersion((FeatureVersion)TestFeatureVersion.TEST_1, Map.of()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateVersion((FeatureVersion)TestFeatureVersion.TEST_1, Map.of("metadata.version", (short)1)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateVersion((FeatureVersion)TestFeatureVersion.TEST_2, Map.of("metadata.version", MetadataVersion.IBP_3_7_IV0.featureLevel())));
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testDefaultLevelAllFeatures(Feature feature) {
        for (FeatureVersion featureImpl : feature.featureVersions()) {
            short defaultLevel = feature.defaultLevel(featureImpl.bootstrapMetadataVersion());
            if (defaultLevel == featureImpl.featureLevel()) continue;
            FeatureVersion otherFeature = feature.fromFeatureLevel(defaultLevel, true);
            Assertions.assertEquals((Object)featureImpl.bootstrapMetadataVersion(), (Object)otherFeature.bootstrapMetadataVersion());
            Assertions.assertTrue((defaultLevel > featureImpl.featureLevel() ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testLatestProductionIsOneOfFeatureValues(Feature feature) {
        Assertions.assertTrue((boolean)feature.hasFeatureVersion(feature.latestProduction));
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testLatestProductionIsNotBehindLatestMetadataVersion(Feature feature) {
        Assertions.assertTrue((feature.latestProduction() >= feature.defaultLevel(MetadataVersion.latestProduction()) ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testLatestProductionDependencyIsProductionReady(Feature feature) {
        for (Map.Entry dependency : feature.latestProduction.dependencies().entrySet()) {
            String featureName = (String)dependency.getKey();
            if (featureName.equals("metadata.version")) continue;
            Feature dependencyFeature = Feature.featureFromName((String)featureName);
            Assertions.assertTrue((boolean)dependencyFeature.isProductionReady(((Short)dependency.getValue()).shortValue()));
        }
    }

    @ParameterizedTest
    @EnumSource(value=Feature.class, names={"UNIT_TEST_VERSION_0", "UNIT_TEST_VERSION_1", "UNIT_TEST_VERSION_2", "UNIT_TEST_VERSION_3", "UNIT_TEST_VERSION_4", "UNIT_TEST_VERSION_5", "UNIT_TEST_VERSION_6", "UNIT_TEST_VERSION_7"}, mode=EnumSource.Mode.EXCLUDE)
    public void testDefaultVersionDependencyIsDefaultReady(Feature feature) {
        for (Map.Entry dependency : feature.defaultVersion(MetadataVersion.LATEST_PRODUCTION).dependencies().entrySet()) {
            String featureName = (String)dependency.getKey();
            if (featureName.equals("metadata.version")) continue;
            Feature dependencyFeature = Feature.featureFromName((String)featureName);
            Assertions.assertTrue(((Short)dependency.getValue() <= dependencyFeature.defaultLevel(MetadataVersion.LATEST_PRODUCTION) ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testDefaultTestVersion(MetadataVersion metadataVersion) {
        short expectedVersion = !metadataVersion.isLessThan(MetadataVersion.latestTesting()) ? (short)2 : (!metadataVersion.isLessThan(MetadataVersion.IBP_3_7_IV0) ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)Feature.TEST_VERSION.defaultLevel(metadataVersion));
    }

    @Test
    public void testUnstableTestVersion() {
        if (MetadataVersion.latestProduction().isLessThan(MetadataVersion.latestTesting())) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.TEST_VERSION.fromFeatureLevel(Feature.TEST_VERSION.latestTesting(), false));
        }
        Feature.TEST_VERSION.fromFeatureLevel(Feature.TEST_VERSION.latestTesting(), true);
    }

    @Test
    public void testValidateWithNonExistentLatestProduction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_0), (String)"Feature UNIT_TEST_VERSION_0 has latest production version UT_FV0_1 which is not one of its feature versions.");
    }

    @Test
    public void testValidateWithLaggingLatestProduction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_1), (String)"Feature UNIT_TEST_VERSION_1 has latest production value UT_FV1_0 smaller than its default version UT_FV1_1 with latest production MV.");
    }

    @Test
    public void testValidateWithDependencyNotProductionReady() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_3), (String)"Feature UNIT_TEST_VERSION_3 has latest production FeatureVersion UT_FV3_1 with dependency UT_FV2_1 that is not production ready. (UNIT_TEST_VERSION_2 latest production: UT_FV2_0)");
    }

    @Test
    public void testValidateWithDefaultValueDependencyAheadOfItsDefaultLevel() {
        if (MetadataVersion.latestProduction().isLessThan(MetadataVersion.latestTesting())) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_5), (String)"Feature UNIT_TEST_VERSION_5 has default FeatureVersion UT_FV5_1 when MV=3.7-IV0 with dependency UT_FV4_1 that is behind its default version UT_FV4_0.");
        }
    }

    @Test
    public void testValidateWithMVDependencyNotProductionReady() {
        if (MetadataVersion.latestProduction().isLessThan(MetadataVersion.latestTesting())) {
            IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_6));
            Assertions.assertEquals((Object)("Feature UNIT_TEST_VERSION_6 has latest production FeatureVersion UT_FV6_1 with MV dependency " + String.valueOf(MetadataVersion.latestTesting()) + " that is not production ready. (MV latest production: " + String.valueOf(MetadataVersion.latestProduction()) + ")"), (Object)exception.getMessage());
        }
    }

    @Test
    public void testValidateWithMVDependencyAheadOfBootstrapMV() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateDefaultValueAndLatestProductionValue((Feature)Feature.UNIT_TEST_VERSION_7));
        Assertions.assertEquals((Object)("Feature UNIT_TEST_VERSION_7 has default FeatureVersion UT_FV7_0 when MV=" + String.valueOf(MetadataVersion.MINIMUM_VERSION) + " with MV dependency 3.7-IV0 that is behind its bootstrap MV " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + "."), (Object)exception.getMessage());
    }

    @Test
    public void testValidateEligibleLeaderReplicasVersion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Feature.validateVersion((FeatureVersion)EligibleLeaderReplicasVersion.ELRV_1, Map.of("metadata.version", MetadataVersion.IBP_4_0_IV0.featureLevel())), (String)"ELR requires MV to be at least 4.0IV1.");
        Assertions.assertDoesNotThrow(() -> Feature.validateVersion((FeatureVersion)EligibleLeaderReplicasVersion.ELRV_1, Map.of("metadata.version", MetadataVersion.IBP_4_0_IV1.featureLevel())), (String)"ELR requires MV to be at least 4.0IV1.");
    }
}

