/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.DefaultDirProvider;

public class PartitionAssignment {
    private final List<Integer> replicas;
    private final List<Uuid> directories;

    public PartitionAssignment(List<Integer> replicas, DefaultDirProvider defaultDirProvider) {
        this.replicas = Collections.unmodifiableList(new ArrayList<Integer>(replicas));
        Uuid[] directories = new Uuid[replicas.size()];
        for (int i = 0; i < directories.length; ++i) {
            directories[i] = defaultDirProvider.defaultDir(replicas.get(i));
        }
        this.directories = Collections.unmodifiableList(Arrays.asList(directories));
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Uuid> directories() {
        return this.directories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionAssignment that = (PartitionAssignment)o;
        return Objects.equals(this.replicas, that.replicas) && Objects.equals(this.directories, that.directories);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.directories);
    }

    public String toString() {
        return "PartitionAssignment(replicas=" + this.replicas + ", directories=" + this.directories + ")";
    }
}

