/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CachedFile;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;

public class FileJwtRetriever
implements JwtRetriever {
    private CachedFile<String> jwtFile;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        File file = cu.validateFileUrl("sasl.oauthbearer.token.endpoint.url");
        this.jwtFile = new CachedFile<String>(file, CachedFile.STRING_JSON_VALIDATING_TRANSFORMER, CachedFile.RefreshPolicy.lastModifiedPolicy());
    }

    @Override
    public String retrieve() throws JwtRetrieverException {
        if (this.jwtFile == null) {
            throw new IllegalStateException("JWT is null; please call configure() first");
        }
        try {
            return this.jwtFile.transformed();
        }
        catch (Exception e) {
            throw new JwtRetrieverException(e);
        }
    }
}

