/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClientCredentialsRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigOrJaas;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsJwtRetriever
implements JwtRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCredentialsJwtRetriever.class);
    private HttpJwtRetriever delegate;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        JaasOptionsUtils jou = new JaasOptionsUtils(saslMechanism, jaasConfigEntries);
        ConfigOrJaas configOrJaas = new ConfigOrJaas(cu, jou);
        String clientId = configOrJaas.clientId();
        String clientSecret = configOrJaas.clientSecret();
        String scope = configOrJaas.scope();
        boolean urlencodeHeader = ClientCredentialsJwtRetriever.validateUrlencodeHeader(cu);
        ClientCredentialsRequestFormatter requestFormatter = new ClientCredentialsRequestFormatter(clientId, clientSecret, scope, urlencodeHeader);
        this.delegate = new HttpJwtRetriever(requestFormatter);
        this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public String retrieve() throws JwtRetrieverException {
        if (this.delegate == null) {
            throw new IllegalStateException("JWT retriever delegate is null; please call configure() first");
        }
        return this.delegate.retrieve();
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly(this.delegate, "JWT retriever delegate");
    }

    static boolean validateUrlencodeHeader(ConfigurationUtils configurationUtils) {
        Boolean urlencodeHeader = (Boolean)configurationUtils.get("sasl.oauthbearer.header.urlencode");
        return Objects.requireNonNullElse(urlencodeHeader, false);
    }
}

