/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.LogAction;

public interface RequestLogFilter
extends Reconfigurable {
    public static final RequestLogFilter MATCH_NONE = new MatchNone();
    public static final RequestLogFilter MATCH_ALL = new MatchAll();

    default public boolean shouldLogRequest(RequestContext ctx, long currentTimeNanos) {
        LogAction action = this.processRequest(ctx, currentTimeNanos);
        return action.shouldLog();
    }

    default public LogAction processRequest(RequestContext ctx, long currentTimeNanos) {
        if (this.shouldLogRequest(ctx, currentTimeNanos)) {
            return LogAction.LOGGED;
        }
        return LogAction.NOT_LOGGED;
    }

    default public LogAction processRequest(RequestContext ctx, AbstractRequest request, long currentTimeNanos) {
        return this.processRequest(ctx, currentTimeNanos);
    }

    @Override
    default public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    @Override
    default public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    @Override
    default public void reconfigure(Map<String, ?> configs) {
    }

    @Override
    default public void configure(Map<String, ?> configs) {
    }

    public static class MatchNone
    implements RequestLogFilter {
        @Override
        public LogAction processRequest(RequestContext ctx, long currentTimeNanos) {
            return LogAction.NOT_LOGGED;
        }
    }

    public static class MatchAll
    implements RequestLogFilter {
        @Override
        public LogAction processRequest(RequestContext ctx, long currentTimeNanos) {
            return LogAction.LOGGED;
        }
    }
}

