/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterPartitionReassignmentsResponse
extends AbstractResponse {
    private final AlterPartitionReassignmentsResponseData data;

    public AlterPartitionReassignmentsResponse(AlterPartitionReassignmentsResponseData data) {
        super(ApiKeys.ALTER_PARTITION_REASSIGNMENTS);
        this.data = data;
    }

    public static AlterPartitionReassignmentsResponse parse(Readable readable, short version, MessageContext context) {
        return new AlterPartitionReassignmentsResponse(new AlterPartitionReassignmentsResponseData(readable, version, context));
    }

    @Override
    public AlterPartitionReassignmentsResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        AlterPartitionReassignmentsResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topicResponse -> topicResponse.partitions().forEach(partitionResponse -> AlterPartitionReassignmentsResponse.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }
}

