/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.message.AlterClusterLinksRequestData;
import org.apache.kafka.common.message.AlterClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClusterLinksResponse;

public class AlterClusterLinksRequest
extends AbstractRequest {
    private final AlterClusterLinksRequestData data;

    public AlterClusterLinksRequest(AlterClusterLinksRequestData data, short version) {
        super(ApiKeys.ALTER_CLUSTER_LINKS, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        AlterClusterLinksResponseData responseData = new AlterClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(errorCode).setErrorMessage(errorMessage);
        return new AlterClusterLinksResponse(responseData);
    }

    @Override
    public AlterClusterLinksRequestData data() {
        return this.data;
    }

    public static AlterClusterLinksRequest parse(Readable readable, short version, MessageContext context) {
        return new AlterClusterLinksRequest(new AlterClusterLinksRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterClusterLinksRequest> {
        private final AlterClusterLinksRequestData data;

        public Builder(AlterClusterLinksRequestData data) {
            super(ApiKeys.ALTER_CLUSTER_LINKS);
            this.data = data;
        }

        public Builder(List<AlterClusterLinksRequestData.AlterClusterLinkData> alterLink, int timeoutMs) {
            super(ApiKeys.ALTER_CLUSTER_LINKS);
            this.data = new AlterClusterLinksRequestData().setAlterClusterLinks(alterLink).setTimeoutMs(timeoutMs);
        }

        public Builder(AlterClusterLinksRequestData.AlterClusterLinkData alterLink, int timeoutMs) {
            this(Collections.singletonList(alterLink), timeoutMs);
        }

        @Override
        public AlterClusterLinksRequest build(short version) {
            return new AlterClusterLinksRequest(this.data, version);
        }
    }
}

