/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public abstract class NettyStreamChannel
implements TransferableChannel {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Logger log;
    private final int fileTransferChunkSize;
    private final int byteBufferTransferChunkSize;

    public NettyStreamChannel(LogContext logContext) {
        this(logContext, 8192, 8192);
    }

    public NettyStreamChannel(LogContext logContext, int fileTransferChunkSize, int byteBufferTransferChunkSize) {
        if (fileTransferChunkSize <= 0) {
            throw new IllegalArgumentException("fileTransferChunkSize must be greater than 0");
        }
        if (byteBufferTransferChunkSize <= 0) {
            throw new IllegalArgumentException("byteWriteChunkSize must be greater than 0");
        }
        this.fileTransferChunkSize = fileTransferChunkSize;
        this.byteBufferTransferChunkSize = byteBufferTransferChunkSize;
        this.log = logContext.logger(NettyStreamChannel.class);
    }

    protected abstract NettyStream nettyStream();

    @Override
    public boolean hasPendingWrites() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
        if (!this.nettyStream().isOpen()) {
            throw new ClosedChannelException();
        }
        long writtenBytes = 0L;
        while (this.nettyStream().isReadyForSending() && count > 0L) {
            int bytesToRead = (int)Math.min(count, (long)this.fileTransferChunkSize);
            ByteBuf byteBuf = this.nettyStream().alloc().buffer(bytesToRead);
            boolean ownershipTransferred = false;
            try {
                int actualBytesRead = byteBuf.writeBytes(fileChannel, position, bytesToRead);
                if (actualBytesRead < 0) break;
                if (actualBytesRead != bytesToRead) {
                    throw new IOException("Failed to read " + bytesToRead + " bytes from file channel, only " + actualBytesRead + " bytes read. Position: " + position + ", count: " + count + ".");
                }
                this.nettyStream().send(byteBuf, false);
                ownershipTransferred = true;
                position += (long)actualBytesRead;
                writtenBytes += (long)actualBytesRead;
                if ((count -= (long)actualBytesRead) != 0L) continue;
                this.nettyStream().flush();
            }
            finally {
                if (ownershipTransferred) continue;
                byteBuf.release();
            }
        }
        return writtenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        if (!this.nettyStream().isOpen()) {
            throw new ClosedChannelException();
        }
        if (offset < 0 || length < 0 || offset > byteBuffers.length - length) {
            throw new IndexOutOfBoundsException();
        }
        long writtenBytes = 0L;
        while (this.nettyStream().isReadyForSending() && length > 0) {
            ByteBuf byteBuf = this.nettyStream().alloc().buffer(this.byteBufferTransferChunkSize);
            boolean ownershipTransferred = false;
            try {
                while (length > 0) {
                    int writeableBytes;
                    int readableBytes = byteBuffers[offset].remaining();
                    if (readableBytes > (writeableBytes = byteBuf.writableBytes())) {
                        int position = byteBuffers[offset].position();
                        int writableLimit = position + writeableBytes;
                        ByteBuffer src = byteBuffers[offset].duplicate();
                        src.limit(writableLimit);
                        byteBuf.writeBytes(src);
                        byteBuffers[offset].position(writableLimit);
                        writtenBytes += (long)writeableBytes;
                        break;
                    }
                    byteBuf.writeBytes(byteBuffers[offset]);
                    writtenBytes += (long)readableBytes;
                    --length;
                    ++offset;
                }
                this.nettyStream().send(byteBuf, false);
                ownershipTransferred = true;
                if (length != 0) continue;
                this.nettyStream().flush();
            }
            finally {
                if (ownershipTransferred) continue;
                byteBuf.release();
            }
        }
        return writtenBytes;
    }

    @Override
    public long write(ByteBuffer[] byteBuffers) throws IOException {
        return this.write(byteBuffers, 0, byteBuffers.length);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return (int)this.write(new ByteBuffer[]{byteBuffer});
    }

    @Override
    public boolean isOpen() {
        return this.nettyStream().isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            Future<Void> closeFuture = this.nettyStream().closeStream();
            if (closeFuture.isDone()) {
                if (!closeFuture.isSuccess()) {
                    throw new IOException("Unexpected error when closing channel.", closeFuture.cause());
                }
                return;
            }
            if (this.nettyStream().inEventLoop()) {
                throw new IllegalThreadStateException("Blocking method called on event loop thread.");
            }
            closeFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return "NettyStreamChannel{" + String.valueOf(this.nettyStream()) + "}";
    }
}

